//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   buf2
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module buf2(y, y_or, y_ff, y_we, 
            x, x_ir, x_fe, x_re, 
            run1, 
            regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [w-1:0]  yR0, yR1;
  reg       [1:0]  cnt;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1 & (cnt==0 | cnt==1);
  assign y_or = run1 & (cnt==1 | cnt==2);
  assign y    = yR1;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt <= 0;
      yR0 <= 0;
      yR1 <= 0;
      
    // Normal operation
    end else begin
      
      if (x_re) begin
        if (y_we) begin
          yR1 <= x;
        end else begin
          if (cnt==0) begin
            yR1 <= x;
          end else begin
            yR0 <= x;
          end
          cnt <= cnt+1;
        end
      
      end else begin
        if (y_we) begin
          yR1 <= yR0;
          cnt <= cnt-1;
        end
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

