//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter buf1_8_x_w             = 8;

  // Outputs
  parameter buf1_8_y_w             = 8;

  // Input control lines
  parameter buf1_8_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter buf1_8_w               = 8;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam buf1_8.x_w             = buf1_8_x_w;
  defparam buf1_8.y_w             = buf1_8_y_w;
  defparam buf1_8.run1_w          = buf1_8_run1_w;
  defparam buf1_8.w               = buf1_8_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                    [buf1_8_y_w-1:0]  buf1_8_y;
  wire                                      buf1_8_y_or;
  wire                                      buf1_8_y_ff;
  wire                                      buf1_8_y_we;

  wire                    [buf1_8_x_w-1:0]  buf1_8_x;
  wire                                      buf1_8_x_ir;
  wire                                      buf1_8_x_fe;
  wire                                      buf1_8_x_re;

  wire                 [buf1_8_run1_w-1:0]  buf1_8_run1;

  wire                                      buf1_8_regWe;
  wire                                      buf1_8_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  buf1 buf1_8(buf1_8_y, buf1_8_y_or, buf1_8_y_ff, buf1_8_y_we,
              buf1_8_x, buf1_8_x_ir, buf1_8_x_fe, buf1_8_x_re, 
              buf1_8_run1, 
              regBus, regWe, regRe, buf1_8_regWe, buf1_8_regRe, clk, clk2, reset);


//==============================================================================
