//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   attnSet
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module attnSet(y, y_or, y_ff, y_we, 
               run1, 
               start, 
               attnCur, 
               attnAdd, 
               attnSub, 
               attnMax, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;

  parameter run1_w            = 0;
  parameter start_w           = 0;
  parameter attnCur_w         = 0;
  parameter attnAdd_w         = 0;
  parameter attnSub_w         = 0;
  parameter attnMax_w         = 0;

  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input          [run1_w-1:0]  run1;
  input         [start_w-1:0]  start;
  input       [attnCur_w-1:0]  attnCur;
  input       [attnAdd_w-1:0]  attnAdd;
  input       [attnSub_w-1:0]  attnSub;
  input       [attnMax_w-1:0]  attnMax;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg       [wy+1:0]  attnNew0, attnNew1;
  reg       [wy+1:0]  attnTest;
  reg       [wy-1:0]  yR;
  reg                 startD;
  reg                 tooLow, tooHigh;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign y_or = startD;
  assign y    = yR;
 
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Calculate new attenuation
    attnNew0 = {1'b0, attnCur} + {attnAdd[wy], attnAdd} - {attnSub[wy], attnSub};
    attnTest = {1'b0, attnMax} - attnNew0;
    
    // Test for overflow
    tooLow   = attnNew0[wy+1];
    tooHigh  = attnTest[wy+1];
    
    case ({tooHigh, tooLow})
      2'b10:   attnNew1 = attnMax;
      2'b01:   attnNew1 = 0;
      default: attnNew1 = attnNew0;
    endcase
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      yR      <= 0;
      startD  <= 0;
      
    // Normal operation
    end else begin
      startD <= start;
      if (start) begin
        yR <= attnNew1[wy-1:0];
      end
    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

