//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter agcRssi_0_x_w             = 24;

  // Outputs
  parameter agcRssi_0_y_w             = 8;

  // Input control lines
  parameter agcRssi_0_run1_w          = 1;
  parameter agcRssi_0_start_w         = 1;
  parameter agcRssi_0_numSmpl_w       = 7;
  parameter agcRssi_0_accSh_w         = 1;

  // Output control lines

  // Eregs
  parameter agcRssi_0_singleAdc_w     = 1;
  parameter agcRssi_0_singleAdc_r     = 0;
  parameter agcRssi_0_singleAdc_s     = 0;

  // Parameters
  parameter agcRssi_0_wx              = 12;
  parameter agcRssi_0_wy              = 8;
  parameter agcRssi_0_wa              = 19;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam agcRssi_0.x_w             = agcRssi_0_x_w;
  defparam agcRssi_0.y_w             = agcRssi_0_y_w;
  defparam agcRssi_0.run1_w          = agcRssi_0_run1_w;
  defparam agcRssi_0.start_w         = agcRssi_0_start_w;
  defparam agcRssi_0.numSmpl_w       = agcRssi_0_numSmpl_w;
  defparam agcRssi_0.accSh_w         = agcRssi_0_accSh_w;
  defparam agcRssi_0.singleAdc_w     = agcRssi_0_singleAdc_w;
  defparam agcRssi_0.singleAdc_r     = agcRssi_0_singleAdc_r;
  defparam agcRssi_0.singleAdc_s     = agcRssi_0_singleAdc_s;
  defparam agcRssi_0.wx              = agcRssi_0_wx;
  defparam agcRssi_0.wy              = agcRssi_0_wy;
  defparam agcRssi_0.wa              = agcRssi_0_wa;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_agcRssi_0_singleAdc                                        = 0;
  defparam  agcRssi_0.R_singleAdc                                        = R_agcRssi_0_singleAdc;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [agcRssi_0_y_w-1:0]  agcRssi_0_y;
  wire                                      agcRssi_0_y_or;
  wire                                      agcRssi_0_y_ff;
  wire                                      agcRssi_0_y_we;

  wire                 [agcRssi_0_x_w-1:0]  agcRssi_0_x;
  wire                                      agcRssi_0_x_ir;
  wire                                      agcRssi_0_x_fe;
  wire                                      agcRssi_0_x_re;

  wire              [agcRssi_0_run1_w-1:0]  agcRssi_0_run1;
  wire             [agcRssi_0_start_w-1:0]  agcRssi_0_start;
  wire           [agcRssi_0_numSmpl_w-1:0]  agcRssi_0_numSmpl;
  wire             [agcRssi_0_accSh_w-1:0]  agcRssi_0_accSh;

  wire                                      agcRssi_0_regWe;
  wire                                      agcRssi_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  agcRssi agcRssi_0(agcRssi_0_y, agcRssi_0_y_or, agcRssi_0_y_ff, agcRssi_0_y_we,
                    agcRssi_0_x, agcRssi_0_x_ir, agcRssi_0_x_fe, agcRssi_0_x_re, 
                    agcRssi_0_run1, 
                    agcRssi_0_start, 
                    agcRssi_0_numSmpl, 
                    agcRssi_0_accSh, 
                    regBus, regWe, regRe, agcRssi_0_regWe, agcRssi_0_regRe, clk, clk2, reset);


//==============================================================================
