//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   agcRssi
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module agcRssi(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               run1, 
               start, 
               numSmpl, 
               accSh, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;
  parameter start_w           = 0;
  parameter numSmpl_w         = 0;
  parameter accSh_w           = 0;

  parameter singleAdc_w       = 0;
  parameter singleAdc_r       = 0;
  parameter singleAdc_s       = 0;
  parameter R_singleAdc       = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wa                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;
  input         [start_w-1:0]  start;
  input       [numSmpl_w-1:0]  numSmpl;
  input         [accSh_w-1:0]  accSh;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire      [singleAdc_w-1:0]  singleAdc_q;
  wire      [singleAdc_w-1:0]  singleAdc_d;
  wire                         singleAdc_weint;
  assign                       singleAdc_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg singleAdc(singleAdc_q, regBus, singleAdc_d, singleAdc_weint, regWe, regRe, clk, reset);
  defparam singleAdc.w    = singleAdc_w;
  defparam singleAdc.rval = singleAdc_r;
  defparam singleAdc.sgn  = singleAdc_s;
  defparam singleAdc.adr  = R_singleAdc;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg         [wx-1:0]  xRe, xIm;
  reg         [wx-1:0]  xReAbs, xImAbs;
  reg         [wa-1:0]  addIn0, addIn1, addIn2, addOut, acc;
  reg         [wa-2:0]  acc1;
  reg            [3:0]  lutIdx;
  reg         [wy-1:0]  rssiBo1, rssiBo2, rssiBo, rssiRes;
  reg                   rssiResRdy, rssiEnd;
  reg           [7:0]   cntIn;
  reg   [accSh_w-1:0]   accShSave;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1==1;
  assign y_or = rssiResRdy;
  assign y    = rssiRes;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Abs of input values -> change this, use only one muxer
    xRe    = x[  wx-1: 0];
    xIm    = x[2*wx-1:wx];
    
    xReAbs = xRe[wx-1]==0 ? xRe : -xRe;
    xImAbs = xIm[wx-1]==0 ? xIm : -xIm;
        
    // Set adder inputs
    addIn0 = xReAbs;
    addIn1 = xImAbs;
    addIn2 = cntIn==0 ? 0 : acc;
    
    addOut = addIn0 + addIn1 + addIn2;
    
    // Shift accumulated data according to the number of input samples
    case ({singleAdc_q, accShSave})
      0: acc1 =  acc[wa-2:0];           // acc
      1: acc1 =  acc[wa-1:1];           // acc >> 1
      2: acc1 = {acc[wa-3:0], 1'b0};    // acc << 1
      3: acc1 =  acc[wa-2:0];           // acc
    endcase
    
    // Get LUT index and partial backoff according to the number of leading
    // zeros of the accumulated value
    casex (acc1[wa-2:wa-10])
      9'b1xxxxxxxx: begin lutIdx = acc1[wa- 3:wa- 6]; rssiBo1 =  0; end
      9'b01xxxxxxx: begin lutIdx = acc1[wa- 4:wa- 7]; rssiBo1 =  6; end
      9'b001xxxxxx: begin lutIdx = acc1[wa- 5:wa- 8]; rssiBo1 = 12; end
      9'b0001xxxxx: begin lutIdx = acc1[wa- 6:wa- 9]; rssiBo1 = 18; end
      9'b00001xxxx: begin lutIdx = acc1[wa- 7:wa-10]; rssiBo1 = 24; end
      9'b000001xxx: begin lutIdx = acc1[wa- 8:wa-11]; rssiBo1 = 30; end
      9'b0000001xx: begin lutIdx = acc1[wa- 9:wa-12]; rssiBo1 = 36; end
      9'b00000001x: begin lutIdx = acc1[wa-10:wa-13]; rssiBo1 = 42; end
      9'b000000001: begin lutIdx = acc1[wa-11:wa-14]; rssiBo1 = 48; end
      9'b000000000: begin lutIdx = 15;                rssiBo1 = 54; end
    endcase

    // Lin -> log conversion
    case (lutIdx)
       0: rssiBo2 = +2; //-0;
       1: rssiBo2 = +1; //-1;
       2: rssiBo2 =  0; //-1;
       3: rssiBo2 =  0; //-1;
       4: rssiBo2 =  0; //-2;
       5: rssiBo2 = -1; //-2;
       6: rssiBo2 = -1; //-3;
       7: rssiBo2 = -2; //-3;
       8: rssiBo2 = -2; //-4;
       9: rssiBo2 = -2; //-4;
      10: rssiBo2 = -3; //-4;
      11: rssiBo2 = -3; //-5;
      12: rssiBo2 = -3; //-5;
      13: rssiBo2 = -4; //-5;
      14: rssiBo2 = -4; //-5;
      15: rssiBo2 = -4; //-6;
    endcase
 
    rssiBo = rssiBo1 + rssiBo2;
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    if (run1==0) begin
      cntIn       <= 0;
      rssiEnd     <= 0;
      rssiResRdy  <= 0;
      
    // Normal operation
    end else begin
 
      // Start by setting the counter
      if (start) begin
        cntIn       <= numSmpl;
        accShSave   <= accSh;
        acc         <= 0;
        rssiEnd     <= 0;
        rssiResRdy  <= 0;
      end else 
      
      // Accumulate RSSI while cntIn != 0
      if (x_re & cntIn!=0) begin
        
        // Count down input samples, accumulate RSSI
        cntIn <= cntIn-1;
        acc   <= addOut;
      
        // Set flag to capture RSSI result in the last state
        if (cntIn==1) begin
          rssiEnd <= 1;
        end
      
      end else // if (rssiStart) ... else if 

      // Calculate back off at the end
      if (rssiEnd==1) begin
        rssiEnd     <= 0;
        rssiResRdy  <= 1;
        rssiRes     <= rssiBo;
      end else

      // Reset output flag
      if (rssiResRdy==1) begin      
        rssiResRdy <= 0;
      end

    end // if (x_re & cntIn!=0)
  end // always

endmodule
//=========================================================================================

