//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   addShiftPass
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module addShiftPass(y, y_or, y_ff, y_we, 
                    x, x_ir, x_fe, x_re, 
                    run1, 
                    regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "s2To1Sel_20.v"
  `include "s1To2Sel_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign s1To2Sel_20_x             = x;
  assign s1To2Sel_20_x_fe          = x_fe;
  assign x_ir                      = s1To2Sel_20_x_ir;

  assign s2To1Sel_20_x1            = s1To2Sel_20_y1;
  assign s2To1Sel_20_x1_fe         = ~s1To2Sel_20_y1_or;
  assign s1To2Sel_20_y1_ff         = ~s2To1Sel_20_x1_ir;

  assign y                         = s2To1Sel_20_y;
  assign y_or                      = s2To1Sel_20_y_or;
  assign s2To1Sel_20_y_ff          = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | s2To1Sel_20_regWe | s1To2Sel_20_regWe;
  assign regReOut = 0 | s2To1Sel_20_regRe | s1To2Sel_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg      [2*w-1:0]  xD, addOut, yAdd;
  reg          [w:0]  addOutRe, addOutIm;
  reg                 x_reD;
  reg                 tgl;
  
  // --------------------------------------------------------------------------------------
  // Assign input selector connections
  assign s1To2Sel_20_sel   = run1==3;
  assign s1To2Sel_20_y0_ff = run1==0;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Use addOut = (x+xD)>>1, for CCF, xD=0
    addOutRe = {x[  w-1], x[  w-1:0]} + {xD[  w-1], xD[  w-1:0]};
    addOutIm = {x[2*w-1], x[2*w-1:w]} + {xD[2*w-1], xD[2*w-1:w]};
    if (run1==1 | run1==2) begin
      addOut   = {addOutIm[w:1], addOutRe[w:1]};
    end else begin
      addOut   = x;
    end
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      tgl     <= 0;
      xD      <= 0;
      x_reD   <= 0;
      yAdd    <= 0;
            
    // Normal operation
    end else begin
      
      // Delay input x_re
      x_reD <= x_re;
      
      // Buffer or reset input, toggle flag
      if (run1==2 & x_re) begin
        xD  <= x;
        tgl <= ~tgl;
      end else
      if (run1!=2) begin
        xD <= 0;
      end
              
      // Buffer adder output
      yAdd <= addOut;

    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Assign output switch
  assign s2To1Sel_20_sel    = run1==3;
  assign s2To1Sel_20_x0     = yAdd;
  assign s2To1Sel_20_x0_fe  = ~((run1==1 & x_reD) | (run1==2 & x_reD & tgl==0));

endmodule
//=========================================================================================

