//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter acq11a_0_x_w             = 20;

  // Outputs
  parameter acq11a_0_yCor2_w         = 8;
  parameter acq11a_0_yCor3_w         = 8;
  parameter acq11a_0_yCor4_w         = 8;
  parameter acq11a_0_yAbs_w          = 8;
  parameter acq11a_0_yPh_w           = 8;

  // Input control lines
  parameter acq11a_0_run1_w          = 1;
  parameter acq11a_0_ssAcqHalt_w     = 1;

  // Output control lines
  parameter acq11a_0_irqSsDet_w      = 1;
  parameter acq11a_0_irqSsEnd_w      = 1;

  // Eregs
  parameter acq11a_0_freqOff_w       = 8;
  parameter acq11a_0_freqOff_r       = 0;
  parameter acq11a_0_freqOff_s       = 1;
  parameter acq11a_0_timeOff_w       = 9;
  parameter acq11a_0_timeOff_r       = 0;
  parameter acq11a_0_timeOff_s       = 0;
  parameter acq11a_0_ampEst_w        = 9;
  parameter acq11a_0_ampEst_r        = 0;
  parameter acq11a_0_ampEst_s        = 0;

  // Parameters
  parameter acq11a_0_wx              = 10;
  parameter acq11a_0_wc              = 8;
  parameter acq11a_0_wa              = 8;
  parameter acq11a_0_wp              = 8;
  parameter acq11a_0_waitSmpl        = 2;
  parameter acq11a_0_StWaitAvgDet    = 0;
  parameter acq11a_0_StWait          = 1;
  parameter acq11a_0_StWaitPreambleEnd = 2;
  parameter acq11a_0_StAcqDone       = 3;

  // Iregs
  parameter acq11a_0_ctfeCnt_w       = 6;
  parameter acq11a_0_ctfeCnt_n       = 1;
  parameter acq11a_0_ctfeCnt_m       = `CLOG2(1);
  parameter acq11a_0_ssCorCnt_w      = 8;
  parameter acq11a_0_ssCorCnt_n      = 1;
  parameter acq11a_0_ssCorCnt_m      = `CLOG2(1);
  parameter acq11a_0_waitCnt_w       = 3;
  parameter acq11a_0_waitCnt_n       = 1;
  parameter acq11a_0_waitCnt_m       = `CLOG2(1);
  parameter acq11a_0_stateAcq_w      = 2;
  parameter acq11a_0_stateAcq_n      = 1;
  parameter acq11a_0_stateAcq_m      = `CLOG2(1);
  parameter acq11a_0_yPhD_w          = 8;
  parameter acq11a_0_yPhD_n          = 3;
  parameter acq11a_0_yPhD_m          = `CLOG2(3);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam acq11a_0.x_w             = acq11a_0_x_w;
  defparam acq11a_0.yCor2_w         = acq11a_0_yCor2_w;
  defparam acq11a_0.yCor3_w         = acq11a_0_yCor3_w;
  defparam acq11a_0.yCor4_w         = acq11a_0_yCor4_w;
  defparam acq11a_0.yAbs_w          = acq11a_0_yAbs_w;
  defparam acq11a_0.yPh_w           = acq11a_0_yPh_w;
  defparam acq11a_0.run1_w          = acq11a_0_run1_w;
  defparam acq11a_0.ssAcqHalt_w     = acq11a_0_ssAcqHalt_w;
  defparam acq11a_0.irqSsDet_w      = acq11a_0_irqSsDet_w;
  defparam acq11a_0.irqSsEnd_w      = acq11a_0_irqSsEnd_w;
  defparam acq11a_0.freqOff_w       = acq11a_0_freqOff_w;
  defparam acq11a_0.freqOff_r       = acq11a_0_freqOff_r;
  defparam acq11a_0.freqOff_s       = acq11a_0_freqOff_s;
  defparam acq11a_0.timeOff_w       = acq11a_0_timeOff_w;
  defparam acq11a_0.timeOff_r       = acq11a_0_timeOff_r;
  defparam acq11a_0.timeOff_s       = acq11a_0_timeOff_s;
  defparam acq11a_0.ampEst_w        = acq11a_0_ampEst_w;
  defparam acq11a_0.ampEst_r        = acq11a_0_ampEst_r;
  defparam acq11a_0.ampEst_s        = acq11a_0_ampEst_s;
  defparam acq11a_0.wx              = acq11a_0_wx;
  defparam acq11a_0.wc              = acq11a_0_wc;
  defparam acq11a_0.wa              = acq11a_0_wa;
  defparam acq11a_0.wp              = acq11a_0_wp;
  defparam acq11a_0.waitSmpl        = acq11a_0_waitSmpl;
  defparam acq11a_0.StWaitAvgDet    = acq11a_0_StWaitAvgDet;
  defparam acq11a_0.StWait          = acq11a_0_StWait;
  defparam acq11a_0.StWaitPreambleEnd = acq11a_0_StWaitPreambleEnd;
  defparam acq11a_0.StAcqDone       = acq11a_0_StAcqDone;
  defparam acq11a_0.ctfeCnt_w       = acq11a_0_ctfeCnt_w;
  defparam acq11a_0.ctfeCnt_n       = acq11a_0_ctfeCnt_n;
  defparam acq11a_0.ctfeCnt_m       = acq11a_0_ctfeCnt_m;
  defparam acq11a_0.ssCorCnt_w      = acq11a_0_ssCorCnt_w;
  defparam acq11a_0.ssCorCnt_n      = acq11a_0_ssCorCnt_n;
  defparam acq11a_0.ssCorCnt_m      = acq11a_0_ssCorCnt_m;
  defparam acq11a_0.waitCnt_w       = acq11a_0_waitCnt_w;
  defparam acq11a_0.waitCnt_n       = acq11a_0_waitCnt_n;
  defparam acq11a_0.waitCnt_m       = acq11a_0_waitCnt_m;
  defparam acq11a_0.stateAcq_w      = acq11a_0_stateAcq_w;
  defparam acq11a_0.stateAcq_n      = acq11a_0_stateAcq_n;
  defparam acq11a_0.stateAcq_m      = acq11a_0_stateAcq_m;
  defparam acq11a_0.yPhD_w          = acq11a_0_yPhD_w;
  defparam acq11a_0.yPhD_n          = acq11a_0_yPhD_n;
  defparam acq11a_0.yPhD_m          = acq11a_0_yPhD_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_acq11a_0_freqOff                                           = 0;
  defparam  acq11a_0.R_freqOff                                           = R_acq11a_0_freqOff;
  parameter R_acq11a_0_timeOff                                           = 1;
  defparam  acq11a_0.R_timeOff                                           = R_acq11a_0_timeOff;
  parameter R_acq11a_0_ampEst                                            = 2;
  defparam  acq11a_0.R_ampEst                                            = R_acq11a_0_ampEst;
  parameter R_acq11a_0_ssNorm_0_cutN_20c4_numCut                         = 3;
  defparam  acq11a_0.R_ssNorm_0_cutN_20c4_numCut                         = R_acq11a_0_ssNorm_0_cutN_20c4_numCut;
  parameter R_acq11a_0_ssCcfAvgDet_0_thr2                                = 4;
  defparam  acq11a_0.R_ssCcfAvgDet_0_thr2                                = R_acq11a_0_ssCcfAvgDet_0_thr2;
  parameter R_acq11a_0_ssCcfAvgDet_0_thr3                                = 5;
  defparam  acq11a_0.R_ssCcfAvgDet_0_thr3                                = R_acq11a_0_ssCcfAvgDet_0_thr3;
  parameter R_acq11a_0_ssCcfAvgDet_0_thr4                                = 6;
  defparam  acq11a_0.R_ssCcfAvgDet_0_thr4                                = R_acq11a_0_ssCcfAvgDet_0_thr4;
  parameter R_acq11a_0_ctfe_0_ctfeCordic_0_thr                           = 7;
  defparam  acq11a_0.R_ctfe_0_ctfeCordic_0_thr                           = R_acq11a_0_ctfe_0_ctfeCordic_0_thr;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_acq11a_0_ssNorm_0_ffIn                                     = 8;
  defparam  acq11a_0.R_ssNorm_0_ffIn                                     = R_acq11a_0_ssNorm_0_ffIn;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [acq11a_0_yCor2_w-1:0]  acq11a_0_yCor2;
  wire                                      acq11a_0_yCor2_or;
  wire                                      acq11a_0_yCor2_ff;
  wire                                      acq11a_0_yCor2_we;

  wire              [acq11a_0_yCor3_w-1:0]  acq11a_0_yCor3;
  wire                                      acq11a_0_yCor3_or;
  wire                                      acq11a_0_yCor3_ff;
  wire                                      acq11a_0_yCor3_we;

  wire              [acq11a_0_yCor4_w-1:0]  acq11a_0_yCor4;
  wire                                      acq11a_0_yCor4_or;
  wire                                      acq11a_0_yCor4_ff;
  wire                                      acq11a_0_yCor4_we;

  wire               [acq11a_0_yAbs_w-1:0]  acq11a_0_yAbs;
  wire                                      acq11a_0_yAbs_or;
  wire                                      acq11a_0_yAbs_ff;
  wire                                      acq11a_0_yAbs_we;

  wire                [acq11a_0_yPh_w-1:0]  acq11a_0_yPh;
  wire                                      acq11a_0_yPh_or;
  wire                                      acq11a_0_yPh_ff;
  wire                                      acq11a_0_yPh_we;

  wire                  [acq11a_0_x_w-1:0]  acq11a_0_x;
  wire                                      acq11a_0_x_ir;
  wire                                      acq11a_0_x_fe;
  wire                                      acq11a_0_x_re;

  wire           [acq11a_0_irqSsDet_w-1:0]  acq11a_0_irqSsDet;
  wire           [acq11a_0_irqSsEnd_w-1:0]  acq11a_0_irqSsEnd;

  wire               [acq11a_0_run1_w-1:0]  acq11a_0_run1;
  wire          [acq11a_0_ssAcqHalt_w-1:0]  acq11a_0_ssAcqHalt;

  wire                                      acq11a_0_regWe;
  wire                                      acq11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  acq11a acq11a_0(acq11a_0_yCor2, acq11a_0_yCor2_or, acq11a_0_yCor2_ff, acq11a_0_yCor2_we,
                  acq11a_0_yCor3, acq11a_0_yCor3_or, acq11a_0_yCor3_ff, acq11a_0_yCor3_we,
                  acq11a_0_yCor4, acq11a_0_yCor4_or, acq11a_0_yCor4_ff, acq11a_0_yCor4_we,
                  acq11a_0_yAbs, acq11a_0_yAbs_or, acq11a_0_yAbs_ff, acq11a_0_yAbs_we,
                  acq11a_0_yPh, acq11a_0_yPh_or, acq11a_0_yPh_ff, acq11a_0_yPh_we,
                  acq11a_0_x, acq11a_0_x_ir, acq11a_0_x_fe, acq11a_0_x_re, 
                  acq11a_0_irqSsDet, 
                  acq11a_0_irqSsEnd, 
                  acq11a_0_run1, 
                  acq11a_0_ssAcqHalt, 
                  regBus, regWe, regRe, acq11a_0_regWe, acq11a_0_regRe, clk, clk2, reset);


//==============================================================================
