function [cfm versionStr] = msgWlanVersionReq(id)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   [cfm versionStr] = msgWlanVersionReq(id)
%
% Inputs:
%   id         - Target identifier
%
% Outputs:
%   cfm        - [MsgId VersionMain VersionBranch VersionTag]
%   versionStr - String 'VersionMain.VersionBranch.VersionTag'
%
% Description:
%   Send version request and get current version numbers. The output
%   is also available as string for debugging.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.VersionReq];
  nCfm  = 5;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.VersionCfm)
    fprintf('Error sending MsgVersionReq\n');
    pause;
  end
  
  % Additional debug output, confirm not checked
  versionStr  = sprintf('%d.%d.%d', cfm(2), cfm(3), cfm(4));
  if (cfm(5) == 1)
    versionStr = [versionStr ' (evaluation)'];
  end
  fprintf('Version %s\n', versionStr);
  
%===============================================================================
