function cfm = msgWlanTxStartCfm(id)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanTxStartCfm(id)
%
% Inputs:
%   id        - Target identifier
%
% Outputs:
%   cfm       - [MsgIdWlan.TxStartCfm, TxStartOK/Failed]
%
% Description:
%   Read and the TX confirm message and check the result.
%   Prints an error message upon failure and possibly stop.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Request confirm
  req   = [];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);

  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.TxStartCfm)
    fprintf('Error sending TX request\n');
    pause
  end

  % Check TX timing status
  if (cfm(2) ~= 0)
    fprintf('Error, TX request too late\n');
  end
  
%===============================================================================
