function cfm = msgWlanTxRun(id, modeTx, lenTx, timerMode, time32)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   msgWlanTxRun(id, modeTx, lenTx, timerMode, time32)
%
% Inputs:
%   id        - Target identifier
%   modeTx      - 0-7 = 6..54 MBit/s                 
%   lenTx       - Length of TX in bytes
%   timerMode   - 0: start immediately
%               - 1: start after a given delay
%               - 2: start at a given time
%   time32      - 32 bit time value         
%
% Outputs:
%   cfm = [MsgIdWlan.TxStartCfm, TimerOkFlag, MsgIdWlan.TxEndCfm]
%
% Description:
%   Send TX request message and handle the corresponding confirms.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Send TX request
  msgWlanTxReq(id, modeTx, lenTx, timerMode, time32);
  
  % Get TX start confirm
  cfmTxStart = msgWlanTxStartCfm(id);
  
  % Possibly get TX end confirm
  if (cfmTxStart(2) == 0)
    cfmTxEnd = msgWlanTxEndCfm(id);
  else
    cfmTxEnd = [];
  end
  
  % Assemble confirms
  cfm = [cfmTxStart cfmTxEnd];
  
% ------------------------------------------------------------------------------

  
  
