function msgWlanTxReq(id, modeTx, lenTx, timerMode, time32)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   msgWlanTxReq(id, modeTx, lenTx, timerMode, time32)
%
% Inputs:
%   id          - Target identifier
%   modeTx      - 0-7, bit(15)=0 -> 11a: 6..54 MBit/s
%                 1-7, bit(15)=1 -> 11b: 1l, 2s, 2l,..., 11l
%   lenTx       - Length of TX in bytes
%   timerMode   - 0: start immediately
%               - 1: start after a given delay
%               - 2: start at a given time
%   time32      - 32 bit time value         
%
% Outputs:
%   --
%
% Description:
%   Send TX request message. The corresponding confirms are handled
%   in separate functions.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Extract time
  timeLo16 = mod(      time32,       2^16);
  timeHi16 = mod(floor(time32/2^16), 2^16);

  % Send message
  req   = [MsgIdWlan.TxReq, modeTx, lenTx, timerMode, timeLo16, timeHi16];
  nCfm  = 0;
  cfm   = sendMsg(id, req, nCfm);
  
%===============================================================================
