function msgWlanTxImmBReq(id, modeTx, lenTx)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanTxImmBReq(id, modeTx, lenTx)
%
% Inputs:
%   id          - Target identifier
%   modeTx      - 1-7 = 1l, 2s, 2l, ..., 11l
%   lenTx       - Length of TX in bytes              
%
% Outputs:
%   --
%
% Description:
%   Send TX immediate request message. Confirms are not handled in this
%   function.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.TxImmBReq, modeTx, lenTx];
  nCfm  = 0;
  cfm   = sendMsg(id, req, nCfm);
  
%===============================================================================
