function msgWlanTxImmAReq(id, modeTx, lenTx)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanTxImmAReq(id, modeTx, lenTx)
%
% Inputs:
%   id          - Target identifier
%   modeTx      - 0-7 = 6..54 MBit/s                 
%   lenTx       - Length of TX in bytes              
%
% Outputs:
%   --
%
% Description:
%   Send TX immediate request message. Confirms are not handled in this
%   function.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.TxImmAReq, modeTx, lenTx];
  nCfm  = 0;
  cfm   = sendMsg(id, req, nCfm);
  
%===============================================================================
