function cfm = msgWlanTxEndCfm(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanTxEndCfm(id)
%
% Inputs:
%   id        - Target identifier
%
% Outputs:
%   cfm         - MsgIdWlan.TxEndCfm
%
% Description:
%   Get the TX end confirm message
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Get TX end confirm
  req   = [];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.TxEndCfm)
    fprintf('Error receiving TX end confirm\n');
    pause
  end
  
%===============================================================================
