function [cfmRxAcqEnd, cfmRxHdr, cfmRxEnd] = msgWlanRxRun2(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   [cfmRxEnd, cfmRxHdr, cfmRxEnd] = msgWlanRxRun2(id)
%
% Inputs:
%   id          - Target identifier
%
% Outputs:
%   cfmRxAcqEnd       - RX acq stop or sync confirm
%   cfmRxHdr          - RX header confirm (or [] if not synced)
%   cfmRxEnd          - RX end confirm (or [] if not synced or header error)
%
% Description:
%   Check the 2nd part of the RX request message confirm and execute
%   the corresponding state machine. If an RX stop confirm is received
%   then just return, otherwise get the RX header confirm and also the
%   RX end confirm message.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Wait for RX sync or acquisition stop confirm
  cfmRxAcqEnd = msgWlanRxAcqEndCfm(id);
  acqStop = (cfmRxAcqEnd(2) ~= 2);
  
  % If ACQ not stopped / sync flag found
  %   -> get RX header cfm and possibly RX end cfm
  if (acqStop == 0)
    cfmRxHdr  = msgWlanRxHdrCfm(id);
    cfmRxEnd  = msgWlanRxEndCfm(id);
  else
    cfmRxHdr  = [];
    cfmRxEnd  = [];
  end
    
% ------------------------------------------------------------------------------

  
  
