function cfm = msgWlanRxRun1(id, timerMode, rxTime)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanRxRun1(id, timerMode, rxTime)
%
% Inputs:
%   id          - Target identifier
%   timerMode   - 0: run until stopped externally
%                 1: run for the given number of sample ticks
%                 2: run until the given time is reached
%   rxTime      - 0..2^32-1
%
% Outputs:
%   cfm         - RX start confirm message
%
% Description:
%   Send RX request message and wait for confirm. This message is the 1st
%   part of the overall RX request handling.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Send RX request
        msgWlanRxReq(id, timerMode, rxTime);
  cfm = msgWlanRxStartCfm(id);
  
% ------------------------------------------------------------------------------

  
  
