function msgWlanRxReq(id, timerMode, rxTime)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   msgWlanRxReq(id, timerMode, rxTime)
%
% Inputs:
%   id          - Target identifier
%   timerMode   - 0: run until stopped externally
%                 1: run for the given number of sample ticks
%                 2: run until the given time is reached
%   rxTime      - 0..2^32-1
%
% Outputs:
%   --
%
% Description:
%   Send RX request message. This function does not wait for any confirms as
%   RX confirms are handled in separate messages.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
  
  % ----------------------------------------------------------------------------
  % Split 32 bit timing into hi/lo word
  rxTimeLo  = mod(rxTime, 2^16);    % Lower 16 bit
  rxTimeHi  = floor(rxTime/2^16);   % Upper 16 bit
  
  % Send message
  req   = [MsgIdWlan.RxReq, timerMode, rxTimeLo, rxTimeHi];
  nCfm  = 0;
  cfm   = sendMsg(id, req, nCfm);
  
% ------------------------------------------------------------------------------

  
  
