function cfm = msgWlanRxHdrCfm(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanRxHdrCfm(id)
%
% Inputs:
%   id    - Target identifier
%
% Outputs:
%   cfm   - [MsgIdWlan.RxHdrCfm HeaderParams(1:8)]
%
% Description:
%   Read the RxHdrCfm and all parameters.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Wait for RX sync or acquisition stop
  cfm = sendMsg(id, [], 9);
    
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.RxHdrCfm)
    fprintf('Error reading RX header confirm\n');
    pause
  end
  
% ------------------------------------------------------------------------------

  
  
