function cfm = msgWlanRxAcqEndCfm(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgWlanRxAcqEndCfm(id)
%
% Inputs:
%   id    - Target identifier
%
% Outputs:
%   cfm   - [MsgIdWlan.RxAcqEndCfm status]
%
% Description:
%   Read the RxAcqEndCfm message and the status.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Wait for RX sync or acquisition stop
  cfm = sendMsg(id, [], 2);
    
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.RxAcqEndCfm)
    fprintf('Error reading ACQ end confirm\n');
    pause
  end
  
% ------------------------------------------------------------------------------

  
  
