function cfm = msgWlanIqBufWriteReq(id, dat)
%===============================================================================
%  Copyright (C) BAY9, 2016
%===============================================================================
%
% Syntax:
%   cfm = msgWlanIqBufWriteReq(id, dat)
%
% Inputs:
%   id          - Target identifier
%   dat         - Complex valued 12 bit integer data
%
% Outputs:
%   cfm         - MsgIdWlan.IqBufWriteCfm
%
% Description:
%   Write data to the IQ sample buffer
%
%     req = [MsgIdWlan.IqBufWriteReq, numSamples, dat0Lo, dat0Hi, dat1Lo,...]
%   
%   The complex input is reformatted to form a 24 bit unsigned integer, 
%   which is split into 16 bit lower, and 8 bit higher part before writing
%   the message.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Reformat input
  dat24 = mod(real(dat), 2^12) + 2^12*mod(imag(dat), 2^12);
  datLo = mod(dat24, 2^16);
  datHi = floor(dat24 / 2^16);
  datLoHi = [datLo(:)'; datHi(:)'];     % Interleave
  datLoHi = datLoHi(:)';
  
  % Send message
  req   = [MsgIdWlan.IqBufWriteReq, length(dat), datLoHi];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.IqBufWriteCfm)
    fprintf('Error sending IqBufWrite request\n');
    pause
  end

%===============================================================================
