function [stat cfm] = msgWlanIqBufModeReq(id, bufMode, nSmpl, rxThr)
%===============================================================================
%  Copyright (C) BAY9, 2016
%===============================================================================
%
% Syntax:
%   [dat cfm] = msgWlanbufModeReq(id, dat)
%
% Inputs:
%   id          - Target identifier
%   bufMode     - IQ buffer mode (0..6)
%   nSmpl       - Number of samples to process (not in mode 0+6)
%   rxThr       - RX threshold (mode 1 only)
%
% Outputs:
%   stat        - Status after RX (mode 6 only)
%   cfm         - MsgIdWlan.IqBufModeCfm
%
% Description:
%   Set the IQ buffer mode
%    0 = Reset/Off
%    1 = RX-RF  -> Buffer
%    2 = TX-BB  -> Buffer
%    3 = Buffer -> RX-BB
%    4 = Buffer -> TX-RF
%    5 = Buffer -> TX-RF (continuously)
%    6 = Check trigger state after RX-RF -> Buffer
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Fill missing parameters
  if (bufMode==0 || bufMode==6)
    nSmpl = 0;
  end
  
  if (bufMode~=1)
    rxThr = 0;
  end
  
  % Send message
  req   = [MsgIdWlan.IqBufModeReq, bufMode, nSmpl, rxThr];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.IqBufModeCfm)
    fprintf('Error sending IqBufMode request\n');
    pause
  end

  % Output
  stat = cfm(2);
  cfm  = cfm(1);
    
%===============================================================================
