function [cfm time32] = msgWlanGetTimeReq(id)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   [cfm time32] = msgWlanGetTimeReq(id)
%
% Inputs:
%   id          - Target identifier
%
% Outputs:
%   cfm         - [MsgIdWlan.GetTimeCfm, TimeLo, TimeHi]
%   time32      - 32 bit time value
%
% Description:
%   Get the current value of the globale timer, return lower and higher 16 bit
%   with the mesage and also the combined 32 bit value.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
      
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.GetTimeReq];
  nCfm  = 3;
  cfm   = sendMsg(id, req, nCfm);

  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.GetTimeCfm)
    fprintf('Error sending MsgGetTimeReq\n');
    pause;
  end
  
  % Combine to 32-bit timer value
  time32 = mod(cfm(2), 2^16) + 2^16*mod(cfm(3), 2^16);

%===============================================================================

