function cfm = msgWlanCfgTxScalingReq(id, txBackOffDb)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgTxScalingReq(id, txBackOffDb)
%
% Inputs:
%   id          - Target identifier
%   txBackOffDb - TX back off in dB
%
% Outputs:
%   cfm         - MsgIdWlan.CfgTxScalingCfm
%
% Description:
%   Send config AGC message, format:
%
%     req = [MsgIdWlan.CfgTxScalingReq, txScaleFac]
%
%   The parameter txScaleFac is determined from the back off in dB as
%   
%     txScaleFac = 25693*10^(-txBackOffDb/20)
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Calculate TX scaling factor depending on backoff
  txScaleFac = round(25693*10^(-txBackOffDb/20));
  if (txScaleFac > 32767 || txScaleFac < 1)
    txScaleFac
    error('TX scaling factor out of range');
  end
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgTxScalingReq, txScaleFac];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgTxScalingCfm)
    fprintf('Error sending TX scaling request\n');
    pause
  end

%===============================================================================
