function cfm = msgWlanCfgTwbReq(id, datLo, datHi, numBits)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgTwbReq(id, datLo, datHi, numBits)
%
% Inputs:
%   id          - Target identifier
%   datLo       - Data bits [15:0]
%   datHi       - Data bits [31:16]
%   numBits     - Number of bits to transmit -> dat[numBits-1:0]
%
% Outputs:
%   cfm         - MsgIdWlan.CfgTwbCfm
%
% Description:
%   Send config 3-wire bus message
%
%     req = [MsgIdWlan.CfgTwbReq, datLo, datHi, numBits]
%
%   The lower numBits bits of the combined value dat = [datHi datLo] are
%   sent via the 3-wire serial bus.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgTwbReq, datLo, datHi, numBits];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgTwbCfm)
    fprintf('Error sending TWB config request\n');
    pause
  end

%===============================================================================
