function cfm = msgWlanCfgGpoReq(id, dat, mask)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgGpoReq(id, dat, mask)
%
% Inputs:
%   id          - Target identifier
%   dat         - Data bits
%   mask        - Mask bits
%
% Outputs:
%   cfm         - MsgIdWlan.CfgGpoCfm + updated data
%
% Description:
%   Send the GPO config request message
%
%     req = [MsgIdWlan.CfgGpoReq, dat, mask]
%
%   and read the updated value. If mask = 0, this will return
%   the current value of the GPOs.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;

  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgGpoReq, dat, mask];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgGpoCfm)
    fprintf('Error sending Gpo config request\n');
    pause
  end

%===============================================================================
