function cfm = msgWlanCfgDcOffCorrTxReq(id, txDcOff)
%===============================================================================
%  Copyright (C) BAY9, 2016
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgDcOffCorrTxReq(id, txDcOff)
%
% Inputs:
%   id        - Target identifier
%   txDcOff   - TX DC offset correction, 12 bit complex
%
% Outputs:
%   cfm       - MsgIdWlan.CfgDcOffCorrTxCfm
%
% Description:
%   Send config TX-DC offset message:
%
%     msg = [MsgIdWlan.CfgDcOffCorrTxReq, TX-DC offset real, TX-DC offset imag]
%
%   in order to set the TX-DC offset correction values.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgDcOffCorrTxReq, real(txDcOff), imag(txDcOff)];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgDcOffCorrTxCfm)
    fprintf('Error sending RX DC offset config request\n');
    pause
  end

%===============================================================================
