function cfm = msgWlanCfgCcaReq(id, timeOutUs, offsetDb)
%===============================================================================
%  Copyright (C) BAY9, 2015
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgCcaReq(id, timeOutUs, offsetDb)
%
% Inputs:
%   id          - Target identifier
%   timeOutUs   - Timeout in microseconds
%   offsetDb    - Gain offset in dB
%
% Outputs:
%   cfm         - MsgIdWlan.CfgCcaCfm
%
% Description:
%   Write CCA parameters to the IP core. Setting timeOutUs=0 disables 
%   CCA so that the IP core returns immediately after a header error.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdWlan.CfgCcaReq, timeOutUs, offsetDb];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgCcaCfm)
    fprintf('Error sending CCA config request\n');
    pause
  end

%===============================================================================
