function cfm = msgWlanCfgAgcTblReq(id, attnReal, pinSetting)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgWlanCfgAgcTblReq(id, attnReal, pinSetting)
%
% Inputs:
%   id          - Target identifier
%   attnReal    - Vector 1x70, range [0..127],   real attenuation values
%   pinSetting  - Vector 1x70, range [0..65535], 16 bin pin settings
%
% Outputs:
%   cfm         - MsgIdWlan.CfgAgcTblCfm
%
% Description:
%   Send config AGC message, format:
%
%     msg = [MsgIdWlan.CfgAgcTblReq, attnReal(0), pinSetting(0), attnReal(1), ...]
%
%   for all possible 70 AGC settings, starting with the lowest attenuation.
%
%   The lowest attenuation should yield the default input noise amplitude
%   of -30 dB FS (=15), or about -24dB at the 80 MHz input before filtering.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdWlan;
    
  % Define message core
  id.core = 'wlan';
    
  % ----------------------------------------------------------------------------
  % Combine input to table settings
  agcTable  = [attnReal; pinSetting];
  agcTable  = agcTable(:)';
  
  % Send message
  req   = [MsgIdWlan.CfgAgcTblReq, agcTable];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdWlan.CfgAgcTblCfm)
    fprintf('Error sending AGC table config request\n');
    pause
  end

%===============================================================================
