function uartFid = uartInit()
%
% Function uartInit:
%   Initialize UART and open UART device file
%
% Syntax:
%   uartFid = uartInit()
%
% Input:
%   --
%
% Output:
%   uartFid: UART device file identifier
%
% Operation:
%   Set UART definitions, open the UART, and return the device file
%   identifier. This function is normally called automatically from
%   sendMsg.m if the UART has not been opened yet.
%
%   Warning: 
%     If the error message occurs that "some" of the settings cannot be
%     applied, then NONE of the settings seems to be used
%      -> revise settings upon error messages
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % UART definitions, define persistent UART FID
  uartDev   = '/dev/ttyUSB0';
  uartBaud  = '2000000';
  
  % ----------------------------------------------------------------------------
  % Setting to put ttyXYZ in raw mode with 8N1 parity
  uartSettings = [...
    ' clocal   ' ...
    ' cs8      ' ...
    ...
    ' nl0      ' ...
    ' cr0      ' ...
    ' tab0     ' ...
    ' bs0      ' ...
    ' vt0      ' ...
    ' ff0      ' ...
    ...
    ' -parenb  ' ...
    ' -parodd  ' ...
    ' -hupcl   ' ...
    ' -cstopb  ' ...
    ' -crtscts ' ...
    ' -ignbrk  ' ...
    ' -brkint  ' ...
    ' -parmrk  ' ...
    ' -inpck   ' ...
    ' -istrip  ' ...
    ' -inlcr   ' ...
    ' -igncr   ' ...
    ' -icrnl   ' ...
    ' -ixon    ' ...
    ' -ixoff   ' ...
    ' -iuclc   ' ...
    ' -ixany   ' ...
    ' -imaxbel ' ...
    ' -opost   ' ...
    ' -olcuc   ' ...
    ' -ocrnl   ' ...
    ' -onlcr   ' ...
    ' -onocr   ' ...
    ' -onlret  ' ...
    ' -ofill   ' ...
    ' -ofdel   ' ...
    ' -isig    ' ...
    ' -icanon  ' ...
    ' -iexten  ' ...
    ' -echo    ' ...
    ' -echoe   ' ...
    ' -echok   ' ...
    ' -echonl  ' ...
    ' -noflsh  ' ...
    ' -tostop  ' ...
    ' -echoctl ' ...
    ' -echoke  ' ...
  ];

  % Set and open UART device
  system(['stty -F ' uartDev ' ' uartBaud ' ' uartSettings]);  
  uartFid = fopen(uartDev, 'r+');
  if (uartFid < 0)
    error('Error opening UART');
  end

  % ----------------------------------------------------------------------------
  % This does not work on Win7, seems to be default on Linux 
  % -> just keep for information, but skip using it
  setStrLinux = [...
    '  cread    ' ...
    ' -ignpar  ' ...
    ' -xcase    ' ...
    ' -echoprt  ' ...
    ' -iutf8    ' ...
    ' -cmspar   ' ...
  ];

% ==============================================================================
