function [gainDb, gainSel] = setupVrfRxGain(id)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   setupVrfRxGain(id)
%
% Input:
%   id           - Target ID
%
% Output:
%   gainDb      - Gain steps in dB
%   gainSel     - Pin settings corresponding to gain steps
%
% Description:
%   Provide an example for setting up the RX gain table as follows and 
%   call msgVrfCfgRxGainTblReq for configuration.
%
%        gainSel[5:0]   |
%       LNA |   VGA    | dB
%       ----+----------+----
%       1 1 | 1 1 1 1  | -20
%       1 1 | 1 1 1 0  | -23
%       1 1 | 1 1 0 1  | -26
%       1 1 | 1 1 0 0  | -29
%       1 0 | 1 1 1 1  | -30
%       1 0 | 1 1 1 0  | -33
%       1 0 | 1 1 0 1  | -36
%       1 0 | 1 1 0 0  | -39
%       0 0 | 1 1 1 1  | -40
%       0 0 | 1 1 1 0  | -43
%       0 0 | 1 1 0 1  | -46
%       0 0 | 1 1 0 0  | -49
%       0 0 | 1 0 1 1  | -52
%           |  ...     |
%       0 0 | 0 0 0 0  | -85
%
%   This table assumes an LNA with 2 steps of 10dB each, and 16 step of another
%   VGA after that. The start highest gain in dB has been selected such that it
%   fits the WLAN requirements -> -20dBfs -6dB filter attenuation results in
%   about -26dBfs which is just above the -30dBfs needed for WLAN.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Define gain table
  gain = [...
    bin2dec('11 1111'),  -20; ...
    bin2dec('11 1110'),  -23; ...
    bin2dec('11 1101'),  -26; ...
    bin2dec('11 1100'),  -29; ...
    bin2dec('10 1111'),  -30; ...
    bin2dec('10 1110'),  -33; ...
    bin2dec('10 1101'),  -36; ...
    bin2dec('10 1100'),  -39; ...
    bin2dec('00 1111'),  -40; ...
    bin2dec('00 1110'),  -43; ...
    bin2dec('00 1101'),  -46; ...
    bin2dec('00 1100'),  -49; ...
    bin2dec('00 1011'),  -52; ...
    bin2dec('00 1010'),  -55; ...
    bin2dec('00 1001'),  -58; ...
    bin2dec('00 1000'),  -61; ...
    bin2dec('00 0111'),  -64; ...
    bin2dec('00 0110'),  -67; ...
    bin2dec('00 0101'),  -70; ...
    bin2dec('00 0100'),  -73; ...
    bin2dec('00 0011'),  -76; ...
    bin2dec('00 0010'),  -79; ...
    bin2dec('00 0001'),  -81; ...
    bin2dec('00 0000'),  -84; ...
  ];
  gainSel   = gain(:, 1)';
  gainDb    = gain(:, 2)';
  gainDelay = 40;
  
  % Call message control handler
  cfm = msgVrfCfgRxGainTblReq(id, gainDelay, gainDb, gainSel);
    
% ------------------------------------------------------------------------------


% ------------------------------------------------------------------------------
% Extended gain table - not used
%   gain = [...
%     bin2dec('11 1 1111'),  -20; ...
%     bin2dec('11 1 1110'),  -23; ...
%     bin2dec('11 1 1101'),  -26; ...
%     bin2dec('11 1 1100'),  -29; ...
%     bin2dec('10 1 1111'),  -30; ...
%     bin2dec('10 1 1110'),  -33; ...
%     bin2dec('10 1 1101'),  -36; ...
%     bin2dec('10 1 1100'),  -39; ...
%     bin2dec('00 1 1111'),  -40; ...
%     bin2dec('00 1 1110'),  -43; ...
%     bin2dec('00 1 1101'),  -46; ...
%     bin2dec('00 1 1100'),  -49; ...
%     bin2dec('00 1 1011'),  -52; ...
%     bin2dec('00 1 1010'),  -55; ...
%     bin2dec('00 1 1001'),  -58; ...
%     bin2dec('00 0 1111'),  -60; ...
%     bin2dec('00 0 1110'),  -63; ...
%     bin2dec('00 0 1101'),  -66; ...
%     bin2dec('00 0 1100'),  -69; ...
%     bin2dec('00 0 1011'),  -72; ...
%     bin2dec('00 0 1010'),  -75; ...
%     bin2dec('00 0 1001'),  -78; ...
%     bin2dec('00 0 1000'),  -81; ...
%     bin2dec('00 0 0111'),  -84; ...
%     bin2dec('00 0 0110'),  -87; ...
%     bin2dec('00 0 0101'),  -90; ...
%     bin2dec('00 0 0100'),  -93; ...
%     bin2dec('00 0 0011'),  -96; ...
%     bin2dec('00 0 0010'),  -99; ...
%     bin2dec('00 0 0001'), -102; ...
%     bin2dec('00 0 0000'), -105; ...
%   ];
% ------------------------------------------------------------------------------
