function setupVrfClkFreqOff(id, clkOffPpm, fC, fS, fBbClk)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   setupVrfClkFreqOff(id, clkOffPpm, fC, fS, fBbClk)
%
% Input:
%   id          - Target ID
%   clkOffPpm   - Clock offset in PPM
%   fC          - Carrier frequency
%   fS          - Sampling frequency
%   fBbClk      - Baseband processing clock frequency
%
% Output:
%   --
%
% Description:
%   The function provides an example how to setup frequency and clock offset
%   in case the RF carrier and the baseband frequency are derived from the
%   same clock source. 
%

  % ----------------------------------------------------------------------------
  % Check input arguments
  if (nargin < 1)
    id = 0;
  end
  if (nargin < 2)
    clkOffPpm = -10;
  end
  if (nargin < 3)
    fC = 2.4e9;
  end
  if (nargin < 4)
    fS = 80e6;
  end
  if (nargin < 5)
    fBbClk = 80e6;
  end
  
  % ----------------------------------------------------------------------------
  % Consistency check
  if (fS > fBbClk)
    fS
    fBbClk
    error('Baseband processing frequency must be greater or equal sampling frequency');
  end
    
  if ( fS/fBbClk > 1/(1+clkOffPpm/1e6) )
    fS
    fBbClk
    clkOffPpm
    error('clkOffPpm > 0, but ratio (sample freq / BB processing freq) too high');
  end

  % Send messages
  byPassClkOff = 0;
  msgVrfCfgClkOffReq(id, clkOffPpm, byPassClkOff);
  msgVrfCfgFreqOffReq(id, clkOffPpm, fC, fS);
  msgVrfCfgDacRateReq(id, fS, fBbClk);
  
% ------------------------------------------------------------------------------
