%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   setVrfAll
%
% Description:
%   Call setupVrf and then use all remaining messages to have a quick test
%   of their functionality. Running 
%     testTxRx11g(1000, 7, 1000, 21.4, 1);
%   results in an error rate of about 50%, 
%     testTxRx11g(1000, 7, 1000, 31.4, 1);
%   should be error free
%
%===============================================================================

% ------------------------------------------------------------------------------
% Setup VRF, basic stuff
setupVrf;

% ------------------------------------------------------------------------------
% RF off again
cfm = msgVrfOnOffReq(idVrf, 0);

% ------------------------------------------------------------------------------
% Set TX IQ imbalance
ampFac = 1.02;
alpha  = 2;
cfm = msgVrfCfgTxIqImbReq(idVrf, ampFac, alpha);

% ------------------------------------------------------------------------------
% Set TX DC offset
dcOffRe = round(-0.15 * 3276.8/sqrt(2));
dcOffIm = round(+0.15 * 3276.8/sqrt(2));
cfm = msgVrfCfgTxDcOffReq(idVrf, dcOffRe, dcOffIm);

% ------------------------------------------------------------------------------
% Setup PA
byPassPa    = 0;
backOffDb   = 12;
phOffMaxDeg = 3;
setupVrfPa(idVrf, byPassPa, backOffDb, phOffMaxDeg);

% ------------------------------------------------------------------------------
% Set channel impulse response
hVal(1) = (+1+3*j)*1.0;  hDel(1) = 0;
hVal(2) = (-3+3*j)*0.1;  hDel(2) = 4;
hVal(3) = (+2-1*j)*0.1;  hDel(3) = 11;
hVal = hVal / sqrt(sum(abs(hVal.^2)));
msgVrfCfgMultiPathReq(idVrf, hVal, hDel);
 
% ------------------------------------------------------------------------------
% Some clock/freq offset settings
clkOffPpm = +10;          % Clock offset in PPM
fC        = 2400e6;       % Carrier frequency
fS        = 80e6;         % Sampling frequency
fBbClk    = 81e6;         % Baseband clock frequency
fSc       = 312500;       % Subcarrier spacing
bandRev   = 0;            % Band reversal off
setupVrfClkFreqOff(idVrf, clkOffPpm, fC, fS, fBbClk);

% ------------------------------------------------------------------------------
% Set RX IQ imbalance
ampFac = 0.98;
alpha  = -2;
cfm = msgVrfCfgRxIqImbReq(idVrf, ampFac, alpha);

% ------------------------------------------------------------------------------
% Set RX DC offset
dcOffRe = +400;
dcOffIm = -400;
cfm = msgVrfCfgRxDcOffReq(idVrf, dcOffRe, dcOffIm);

% ------------------------------------------------------------------------------
% RF on again
cfm = msgVrfOnOffReq(idVrf, 1);

% ==============================================================================
% Adopt WLAN settings
cfm = msgWlanCfgTimerPrescaleReq(idWlanTx, fS, fBbClk*4);
cfm = msgWlanCfgTimerPrescaleReq(idWlanRx, fS, fBbClk*4);
cfm = msgWlanCfgTtReq(idWlanRx, fC, fSc, bandRev);

% ==============================================================================
