%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   setVrf
%
% Description:
%   This script prepares the VRF and the included IP WLAN IP cores. In detail,
%   the following steps are taken:
%     - Reset + boot VRF
%     - Configure VRF
%       o Input scaling = 12 dB backoff
%       o Gain table, assume 51 step of 1.7 dB each, the highest
%         gain being choses such that it is the input level is a bit
%         bit higher than needed for the initial stage of the WLAN system
%       o Set an assumed AGC delay of 6 samples
%     - Reset + boot WLAN-TX +/ WLAN-RX
%     - Run AGC calibration for WLAN-RX
%
% ==============================================================================

% ------------------------------------------------------------------
% Allow to default global variable for FPGA board
global idStd;
if (isempty(idStd))
  idStd.tgt   = 'fpga0';
  idStd.top   = 'vrfX';
  idStd.inst  = 0;
end

% ------------------------------------------------------------------
% Define instances VRF 0, WLAN 0+1
idVrf     = idStd;
idWlanTx  = idStd;
idWlanRx  = idStd;
idWlanRx.inst = 1;    % Overwrite instance

% Define messages
global MsgIdVrf;
def_MsgId_vrf;

% ------------------------------------------------------------------
% Reset + boot + configure VRF
fprintf('-------------------------------------\n');
fprintf('Reset + boot VRF system ... \n');
msgVrfResetReq(idVrf);
msgVrfBootReq(idVrf);
msgVrfVersionReq(idVrf);
msgVrfLedBlinkReq(idVrf);

% Switch VRF off (paranoia setting)
fprintf('Set RF off\n')
cfm = msgVrfOnOffReq(idVrf, 0);

% TX input scaling - assume 12 dB backoff
fprintf('Set input scaling\n')
cfm = msgVrfCfgTxInpScReq(idVrf, 12);

% Set channel gain to -100 (paranoia setting, not really needed)
fprintf('Set channel gain to -100 dB initially\n')
cfm = msgVrfCfgChGainReq(idVrf, -100);

% ----------------------------
% Emulate RF gain settings, delay + steps, use default setup function
fprintf('Set RF gain delay and RF gain step table\n');
[gainDb, gainSel] = setupVrfRxGain(idVrf);

% ----------------------------
% Other options, testing AGC

% Use different gain delays, remember this is in 80 MHz samples
% gainDelay = 40;  % 0.5us

% Virtual RF gain table, misc settings tested
% gainDb    = -20+6+[+0:-1.7:-85];            % 1.7dB steps
% gainDb    = -20+6+[0:-3:-120];              % 3 dB steps
% gainDb    = -20+6+[0:-1:-120];              % 1 dB steps
% gainDb    = -20+6-cumsum(1+2*rand(1, 50));  % Random setting, 50 step from 1..3 dB

% Set arbitrary pins and configure RX gain table
% s = 1; 
% for k = 1:length(gainDb)
%   gainSel(k) = s; for l=1:7;s = s*2; s = bitxor(s, (2^7+2^5+2^3+2^1+2^0)*(s>=128));end;
% end
% cfm = msgVrfCfgRxGainTblReq(idVrf, gainDelay, gainDb, gainSel);

% ----------------------------
% Switch on VRF
fprintf('Set RF on\n');
cfm = msgVrfOnOffReq(idVrf, 1);

% ==============================================================================
% WLAN config definitions
cfgWlan.ifSel       = 0;        % Zero-IF
cfgWlan.bandRev     = 0;        % No band reversal
cfgWlan.singleAdc   = 0;        % Use both ADCs

cfgWlan.paDelay     = 0;        % Set PA pin immediately
cfgWlan.txDelay     = 0;        % Set TX pin immediately
cfgWlan.bbDelay     = 0;        % Start TX BB output

cfgWlan.txBackOffDb = 12;       % Define TX backoff

cfgWlan.fc          = 0;        % Carrier frequency
cfgWlan.fSc         = 312500;   % Subcarrier spacing
cfgWlan.ttRev       = 0;        % Reversed time tracking off

cfgWlan.agcRunMode  = 2;        % Normal AGC mode
cfgWlan.agcInitAttn = 0;        % Initial attenuation step

% Reset + setup WLAN-TX
fprintf('-------------------------------------\n');
fprintf('Boot + setup WLAN-TX\n');
resetPinTx = 2^0;
msgVrfCfgGpoReq(idVrf, resetPinTx, resetPinTx);
msgVrfCfgGpoReq(idVrf,          0, resetPinTx);
setupWlan(idWlanTx, cfgWlan);

% Reset + setup WLAN-RX
fprintf('-------------------------------------\n');
fprintf('Boot + setup WLAN-RX\n');
resetPinRx = 2^1;
msgVrfCfgGpoReq(idVrf, resetPinRx, resetPinRx);
msgVrfCfgGpoReq(idVrf,          0, resetPinRx);
setupWlan(idWlanRx, cfgWlan);

% ------------------------------------------------------------------
% RF-AGC calibration of RX path
fprintf('-------------------------------------\n');
fprintf('Calibrate WLAN-RX AGC table\n');
attnDb = -gainDb;
pinSet = gainSel;
setupWlanAgc(idWlanRx, attnDb, pinSet);

% ==============================================================================
