//==============================================================================
//  Copyright (C) BAY9, 2014
//==============================================================================
// -----------------------------------------------------------------------------
// Simple top module including the IP core for synthesis testing
//
// Connect UART, clk, reset + 1 LED to FPGA pins and uses a dummy logic
// to prevent synthesis tools to remove other logic during optimization.

module vrfX(uartOut,
            uartIn,
            uartGnd,
            clkExt,
            resetExt,
            ledVrf, ledTx, ledRx);

  // UART interface, clock input, LED
  output        uartOut;
  input         uartIn;
  output        uartGnd;
  input         clkExt;
  input         resetExt;
  output        ledVrf;
  output        ledTx;
  output        ledRx;

  // Clock definition
  wire clk;
  
  // ---------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_vrf.v"
  `include "def_Const_wlan.v"

  // ---------------------------------------------------------------------------
  // Define main module
  `include "vrf_0.v"

  // ---------------------------------------------------------------------------
  // Assignment of inputs + outputs
  assign vrf_0_uartIn       = uartIn;
  assign uartOut            = vrf_0_uartOut;
  assign uartGnd            = 0;
  
  assign vrf_0_resetIn      = ~resetExt;    // Internal reset is active high
  assign vrf_0_ctrlSel      = 1;            // UART only
  
  assign ledVrf             = vrf_0_statLed[0] | ~resetExt; // LED on during reset
  
  // ---------------------------------------------------------------------------
  // Clock
  pllX pll(clkExt, clk);
  
  // ---------------------------------------------------------------------------
  // Connect to PHY0 (wlan_0 of wlan)
  `include "wlan_0.v"

  // Reset TX core via GPO 0
  assign  wlan_0_resetIn          = vrf_0_gpo[0];

  // Connect ADC (not connected here -> TX)
  assign  wlan_0_adcRe            = 0;
  assign  wlan_0_adcIm            = 0;

  // Connect DAC
  assign  vrf_0_dacRe             = wlan_0_dacRe;
  assign  vrf_0_dacIm             = wlan_0_dacIm;
  assign  wlan_0_dac_ir           = vrf_0_dac_ir;

  // Connect TX data buffer
  assign  wlan_0_dataTx           = vrf_0_dataPhy0Tx;
  assign  vrf_0_dataPhy0Tx_ir     = wlan_0_dataTx_ir;
  assign  wlan_0_dataTx_or        = vrf_0_dataPhy0Tx_or; // Ignored in PHY mode
  
  // Use ctrl interface for messages
  assign  wlan_0_ctrlSel          = 0;
  
  // vrf_0_ctrlPhy0Out -> wlan_0_ctrlIn
  assign  wlan_0_ctrlIn           = vrf_0_ctrlPhy0Out;
  assign  wlan_0_ctrlIn_or        = vrf_0_ctrlPhy0Out_or;
  assign  vrf_0_ctrlPhy0Out_ir    = wlan_0_ctrlIn_ir;
  
  // wlan_0_ctrlOut -> vrf_0_ctrlPhy0In
  assign  vrf_0_ctrlPhy0In        = wlan_0_ctrlOut;
  assign  vrf_0_ctrlPhy0In_or     = wlan_0_ctrlOut_or;
  assign  wlan_0_ctrlOut_ir       = vrf_0_ctrlPhy0In_ir;
  
  // Status LED for TX
  assign  ledTx                   = wlan_0_statLed[0];

// Unused signals of TX core:
// resetOut attn attn_or paOn rxOn txOn twbClk twbDat twbEn 
// dataRx dataRx_or uartOut uartIn gpo gpi

  // ---------------------------------------------------------------------------
  // Connect to PHY1 (wlan_1 of wlan)
  `include "wlan_1.v"

  // Reset RX core via GPO 1
  assign  wlan_1_resetIn          = vrf_0_gpo[1];

  // Connect ADC
  assign  wlan_1_adcRe            = vrf_0_adcRe;
  assign  wlan_1_adcIm            = vrf_0_adcIm;
  assign  wlan_1_adc_or           = vrf_0_adc_or;

  // Connect DACs - set input ready to allow fake TX
  assign  wlan_1_dac_ir           = 1;
  
  // Connect RX gain control to VRF
  assign  vrf_0_gainSel           = wlan_1_attn[VrfGainSelWidth_C-1:0];

  // Connect RX data buffer
  assign  vrf_0_dataPhy1Rx        = wlan_1_dataRx;
  assign  vrf_0_dataPhy1Rx_or     = wlan_1_dataRx_or;
//  assign  wlan_1_dataRx_ir        = vrf_0_dataPhy1Rx_ir;  // Not needed

  // Use ctrl interface for messages
  assign  wlan_1_ctrlSel          = 0;
  
  // vrf_0_ctrlPhy1Out -> wlan_1_ctrlIn
  assign  wlan_1_ctrlIn           = vrf_0_ctrlPhy1Out;
  assign  wlan_1_ctrlIn_or        = vrf_0_ctrlPhy1Out_or;
  assign  vrf_0_ctrlPhy1Out_ir    = wlan_1_ctrlIn_ir;
  
  // wlan_1_ctrlOut -> vrf_0_ctrlPhy1In
  assign  vrf_0_ctrlPhy1In        = wlan_1_ctrlOut;
  assign  vrf_0_ctrlPhy1In_or     = wlan_1_ctrlOut_or;
  assign  wlan_1_ctrlOut_ir       = vrf_0_ctrlPhy1In_ir;
  
  // Status LED for TX
  assign  ledRx                   = wlan_1_statLed[0];

// Unused signals of RX core:
// resetOut dacRe dacIm attn_or paOn rxOn txOn twbClk twbDat twbEn
// dataTx dataTx_ir dataTx_or uartOut uartIn gpo gpi

endmodule

//==============================================================================

