//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   wgn
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module wgn(y, y_or, y_ff, y_we, 
           run1, 
           regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;

  parameter run1_w            = 0;

  parameter n                 = 0;
  parameter cf                = 0;
  parameter w                 = 0;
  parameter p00               = 0;
  parameter p01               = 0;
  parameter p02               = 0;
  parameter p03               = 0;
  parameter p04               = 0;
  parameter p05               = 0;
  parameter p06               = 0;
  parameter p07               = 0;
  parameter p08               = 0;
  parameter p09               = 0;
  parameter p10               = 0;
  parameter p11               = 0;
  parameter w00               = 0;
  parameter w01               = 0;
  parameter w02               = 0;
  parameter w03               = 0;
  parameter w04               = 0;
  parameter w05               = 0;
  parameter w06               = 0;
  parameter w07               = 0;
  parameter w08               = 0;
  parameter w09               = 0;
  parameter w10               = 0;
  parameter w11               = 0;
  parameter r00a              = 0;
  parameter r00b              = 0;
  parameter r01a              = 0;
  parameter r01b              = 0;
  parameter r02a              = 0;
  parameter r02b              = 0;
  parameter r03a              = 0;
  parameter r03b              = 0;
  parameter r04a              = 0;
  parameter r04b              = 0;
  parameter r05a              = 0;
  parameter r05b              = 0;
  parameter r06a              = 0;
  parameter r06b              = 0;
  parameter r07a              = 0;
  parameter r07b              = 0;
  parameter r08a              = 0;
  parameter r08b              = 0;
  parameter r09a              = 0;
  parameter r09b              = 0;
  parameter r10a              = 0;
  parameter r10b              = 0;
  parameter r11a              = 0;
  parameter r11b              = 0;

  parameter s00a_w            = 0;
  parameter s00a_n            = 0;
  parameter s00a_m            = 0;
  parameter s00b_w            = 0;
  parameter s00b_n            = 0;
  parameter s00b_m            = 0;
  parameter s01a_w            = 0;
  parameter s01a_n            = 0;
  parameter s01a_m            = 0;
  parameter s01b_w            = 0;
  parameter s01b_n            = 0;
  parameter s01b_m            = 0;
  parameter s02a_w            = 0;
  parameter s02a_n            = 0;
  parameter s02a_m            = 0;
  parameter s02b_w            = 0;
  parameter s02b_n            = 0;
  parameter s02b_m            = 0;
  parameter s03a_w            = 0;
  parameter s03a_n            = 0;
  parameter s03a_m            = 0;
  parameter s03b_w            = 0;
  parameter s03b_n            = 0;
  parameter s03b_m            = 0;
  parameter s04a_w            = 0;
  parameter s04a_n            = 0;
  parameter s04a_m            = 0;
  parameter s04b_w            = 0;
  parameter s04b_n            = 0;
  parameter s04b_m            = 0;
  parameter s05a_w            = 0;
  parameter s05a_n            = 0;
  parameter s05a_m            = 0;
  parameter s05b_w            = 0;
  parameter s05b_n            = 0;
  parameter s05b_m            = 0;
  parameter s06a_w            = 0;
  parameter s06a_n            = 0;
  parameter s06a_m            = 0;
  parameter s06b_w            = 0;
  parameter s06b_n            = 0;
  parameter s06b_m            = 0;
  parameter s07a_w            = 0;
  parameter s07a_n            = 0;
  parameter s07a_m            = 0;
  parameter s07b_w            = 0;
  parameter s07b_n            = 0;
  parameter s07b_m            = 0;
  parameter s08a_w            = 0;
  parameter s08a_n            = 0;
  parameter s08a_m            = 0;
  parameter s08b_w            = 0;
  parameter s08b_n            = 0;
  parameter s08b_m            = 0;
  parameter s09a_w            = 0;
  parameter s09a_n            = 0;
  parameter s09a_m            = 0;
  parameter s09b_w            = 0;
  parameter s09b_n            = 0;
  parameter s09b_m            = 0;
  parameter s10a_w            = 0;
  parameter s10a_n            = 0;
  parameter s10a_m            = 0;
  parameter s10b_w            = 0;
  parameter s10b_n            = 0;
  parameter s10b_m            = 0;
  parameter s11a_w            = 0;
  parameter s11a_n            = 0;
  parameter s11a_m            = 0;
  parameter s11b_w            = 0;
  parameter s11b_n            = 0;
  parameter s11b_m            = 0;
  parameter tgl_w             = 0;
  parameter tgl_n             = 0;
  parameter tgl_m             = 0;
  parameter yR_w              = 0;
  parameter yR_n              = 0;
  parameter yR_m              = 0;
  parameter dE0_w             = 0;
  parameter dE0_n             = 0;
  parameter dE0_m             = 0;
  parameter dE1_w             = 0;
  parameter dE1_n             = 0;
  parameter dE1_m             = 0;
  parameter dO_w              = 0;
  parameter dO_n              = 0;
  parameter dO_m              = 0;
  parameter xp_w              = 0;
  parameter xp_n              = 0;
  parameter xp_m              = 0;
  parameter xm_w              = 0;
  parameter xm_n              = 0;
  parameter xm_m              = 0;
  parameter xa_w              = 0;
  parameter xa_n              = 0;
  parameter xa_m              = 0;
  parameter xa0_w             = 0;
  parameter xa0_n             = 0;
  parameter xa0_m             = 0;
  parameter xa1_w             = 0;
  parameter xa1_n             = 0;
  parameter xa1_m             = 0;
  parameter xa2_w             = 0;
  parameter xa2_n             = 0;
  parameter xa2_m             = 0;
  parameter xb_w              = 0;
  parameter xb_n              = 0;
  parameter xb_m              = 0;
  parameter xb0_w             = 0;
  parameter xb0_n             = 0;
  parameter xb0_m             = 0;
  parameter xb1_w             = 0;
  parameter xb1_n             = 0;
  parameter xb1_m             = 0;
  parameter xb2_w             = 0;
  parameter xb2_n             = 0;
  parameter xb2_m             = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg            [s00a_w-1:0]  s00a;
  reg            [s00b_w-1:0]  s00b;
  reg            [s01a_w-1:0]  s01a;
  reg            [s01b_w-1:0]  s01b;
  reg            [s02a_w-1:0]  s02a;
  reg            [s02b_w-1:0]  s02b;
  reg            [s03a_w-1:0]  s03a;
  reg            [s03b_w-1:0]  s03b;
  reg            [s04a_w-1:0]  s04a;
  reg            [s04b_w-1:0]  s04b;
  reg            [s05a_w-1:0]  s05a;
  reg            [s05b_w-1:0]  s05b;
  reg            [s06a_w-1:0]  s06a;
  reg            [s06b_w-1:0]  s06b;
  reg            [s07a_w-1:0]  s07a;
  reg            [s07b_w-1:0]  s07b;
  reg            [s08a_w-1:0]  s08a;
  reg            [s08b_w-1:0]  s08b;
  reg            [s09a_w-1:0]  s09a;
  reg            [s09b_w-1:0]  s09b;
  reg            [s10a_w-1:0]  s10a;
  reg            [s10b_w-1:0]  s10b;
  reg            [s11a_w-1:0]  s11a;
  reg            [s11b_w-1:0]  s11b;
  reg             [tgl_w-1:0]  tgl;
  reg              [yR_w-1:0]  yR;
  reg             [dE0_w-1:0]  dE0;
  reg             [dE1_w-1:0]  dE1;
  reg              [dO_w-1:0]  dO;
  reg              [xp_w-1:0]  xp;
  reg              [xm_w-1:0]  xm;
  reg              [xa_w-1:0]  xa;
  reg             [xa0_w-1:0]  xa0;
  reg             [xa1_w-1:0]  xa1;
  reg             [xa2_w-1:0]  xa2;
  reg              [xb_w-1:0]  xb;
  reg             [xb0_w-1:0]  xb0;
  reg             [xb1_w-1:0]  xb1;
  reg             [xb2_w-1:0]  xb2;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "wdfTpaV2_14c12.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | wdfTpaV2_14c12_regWe;
  assign regReOut = 0 | wdfTpaV2_14c12_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
//  reg   [w-1:0] xa, xa0, xa1, xa2; 
//  reg   [w-1:0] xb, xb0, xb1, xb2;
//  reg   [w-1:0] xp, xm; 
//  reg   [w-1:0] dO, dE0, dE1;
//  reg     [w:0] yR;
//  reg           tgl;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign y_or = run1;
  assign y    = yR[w:1];

  // --------------------------------------------------------------------------------------
  // Connection to wdfTpaV2 submodule input
  assign  wdfTpaV2_14c12_a1 = xp;
  assign  wdfTpaV2_14c12_a2 = dE1;
  assign  wdfTpaV2_14c12_c  = cf;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
        
      // Set state registers to init values
      s00a <= r00a;  s00b <= r00b;
      s01a <= r01a;  s01b <= r01b;
      s02a <= r02a;  s02b <= r02b;
      s03a <= r03a;  s03b <= r03b;
      s04a <= r04a;  s04b <= r04b;
      s05a <= r05a;  s05b <= r05b;
      s06a <= r06a;  s06b <= r06b;
      s07a <= r07a;  s07b <= r07b;
      s08a <= r08a;  s08b <= r08b;
      s09a <= r09a;  s09b <= r09b;
      s10a <= r10a;  s10b <= r10b;
      s11a <= r11a;  s11b <= r11b;
      
      // Reset all other registers
      xa <= 0; xa0 <= 0; xa1 <= 0; xa2 <= 0;
      xb <= 0; xb0 <= 0; xb1 <= 0; xb2 <= 0;
      xp <= 0; xm <= 0;
      dO <= 0; dE0 <= 0; dE1 <= 0;
      yR <= 0;
      tgl <= 0;
      
    // Normal operation
    end else begin
      
      if (y_we) begin
        
        // LFSR register feedback
        s00a <= (s00a<<1) ^ (s00a[w00-1] ? p00 : 0);
        s01a <= (s01a<<1) ^ (s01a[w01-1] ? p01 : 0);
        s02a <= (s02a<<1) ^ (s02a[w02-1] ? p02 : 0);
        s03a <= (s03a<<1) ^ (s03a[w03-1] ? p03 : 0);
        s04a <= (s04a<<1) ^ (s04a[w04-1] ? p04 : 0);
        s05a <= (s05a<<1) ^ (s05a[w05-1] ? p05 : 0);
        s06a <= (s06a<<1) ^ (s06a[w06-1] ? p06 : 0);
        s07a <= (s07a<<1) ^ (s07a[w07-1] ? p07 : 0);
        s08a <= (s08a<<1) ^ (s08a[w08-1] ? p08 : 0);
        s09a <= (s09a<<1) ^ (s09a[w09-1] ? p09 : 0);
        s10a <= (s10a<<1) ^ (s10a[w10-1] ? p10 : 0);
        s11a <= (s11a<<1) ^ (s11a[w11-1] ? p11 : 0);

        s00b <= (s00b<<1) ^ (s00b[w00-1] ? p00 : 0);
        s01b <= (s01b<<1) ^ (s01b[w01-1] ? p01 : 0);
        s02b <= (s02b<<1) ^ (s02b[w02-1] ? p02 : 0);
        s03b <= (s03b<<1) ^ (s03b[w03-1] ? p03 : 0);
        s04b <= (s04b<<1) ^ (s04b[w04-1] ? p04 : 0);
        s05b <= (s05b<<1) ^ (s05b[w05-1] ? p05 : 0);
        s06b <= (s06b<<1) ^ (s06b[w06-1] ? p06 : 0);
        s07b <= (s07b<<1) ^ (s07b[w07-1] ? p07 : 0);
        s08b <= (s08b<<1) ^ (s08b[w08-1] ? p08 : 0);
        s09b <= (s09b<<1) ^ (s09b[w09-1] ? p09 : 0);
        s10b <= (s10b<<1) ^ (s10b[w10-1] ? p10 : 0);
        s11b <= (s11b<<1) ^ (s11b[w11-1] ? p11 : 0);

        // Toggle flag for adding up conditionally
        tgl <= ~tgl;

        // Add up LFSRoutputs
        xa0 <= {{w-9{s00a[8]}}, s00a[8:0]} - {{w-9{s01a[8]}}, s01a[8:0]} 
             + {{w-9{s02a[8]}}, s02a[8:0]} - {{w-9{s03a[8]}}, s03a[8:0]};
        xa1 <= {{w-9{s04a[8]}}, s04a[8:0]} - {{w-9{s05a[8]}}, s05a[8:0]} 
             + {{w-9{s06a[8]}}, s06a[8:0]} - {{w-9{s07a[8]}}, s07a[8:0]};
        xa2 <= {{w-9{s08a[8]}}, s08a[8:0]} - {{w-9{s09a[8]}}, s09a[8:0]} 
             + {{w-9{s10a[8]}}, s10a[8:0]} - {{w-9{s11a[8]}}, s11a[8:0]};
        if (tgl==1) begin
          xa <= xa0 + xa1 + xa2;
        end else begin
          xa <= -(xa0 + xa1 + xa2);
        end

        xb0 <= {{w-9{s00b[8]}}, s00b[8:0]} - {{w-9{s01b[8]}}, s01b[8:0]} 
             + {{w-9{s02b[8]}}, s02b[8:0]} - {{w-9{s03b[8]}}, s03b[8:0]};
        xb1 <= {{w-9{s04b[8]}}, s04b[8:0]} - {{w-9{s05b[8]}}, s05b[8:0]} 
             + {{w-9{s06b[8]}}, s06b[8:0]} - {{w-9{s07b[8]}}, s07b[8:0]};
        xb2 <= {{w-9{s08b[8]}}, s08b[8:0]} - {{w-9{s09b[8]}}, s09b[8:0]} 
             + {{w-9{s10b[8]}}, s10b[8:0]} - {{w-9{s11b[8]}}, s11b[8:0]};
        xb  <= xb0 + xb1 + xb2;

        // Combine xa/xb
        xp  <= xa + xb;
        xm  <= xa - xb;

        // Assign filter delays
        dO  <= xm;
        dE0 <= wdfTpaV2_14c12_b2;
        dE1 <= dE0;

        // Add up sign extended here
        yR  <= {dO[w-1], dO} + {wdfTpaV2_14c12_b1[w-1], wdfTpaV2_14c12_b1};

      end
    end // if (run1==0) ... else
  end // always

  // --------------------------------------------------------------------------------------

endmodule
//=========================================================================================

