//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   txScale
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module txScale(yRe, yRe_or, yRe_ff, yRe_we, 
               yIm, yIm_or, yIm_ff, yIm_we, 
               xRe, xRe_ir, xRe_fe, xRe_re, 
               xIm, xIm_ir, xIm_fe, xIm_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter txFactor_w        = 0;
  parameter txFactor_r        = 0;
  parameter txFactor_s        = 0;
  parameter R_txFactor        = 0;

  parameter w                 = 0;
  parameter ws                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire       [txFactor_w-1:0]  txFactor_q;
  wire       [txFactor_w-1:0]  txFactor_d;
  wire                         txFactor_weint;
  assign                       txFactor_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg txFactor(txFactor_q, regBus, txFactor_d, txFactor_weint, regWe, regRe, clk, reset);
  defparam txFactor.w    = txFactor_w;
  defparam txFactor.rval = txFactor_r;
  defparam txFactor.sgn  = txFactor_s;
  defparam txFactor.adr  = R_txFactor;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [w-1:0] yReR, yImR;
  reg             yOrR;
  wire [w+ws-1:0] mulRe, mulIm;
  wire    [w-1:0] satRe, satIm;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  
  assign yRe_or = yOrR;
  assign yIm_or = yOrR;
  assign yRe    = yReR;
  assign yIm    = yImR;
  
  // --------------------------------------------------------------------------------------
  // Multiplier
  mulSi mul0(mulRe, xRe, {1'b0, txFactor_q});
  defparam mul0.c_w = w+ws;
  defparam mul0.a_w = w;
  defparam mul0.b_w = ws+1;
  
  mulSi mul1(mulIm, xIm, {1'b0, txFactor_q});
  defparam mul1.c_w = w+ws;
  defparam mul1.a_w = w;
  defparam mul1.b_w = ws+1;

  // Saturation
  sat sat0(satRe, mulRe[w+ws-1:12]);
  defparam sat0.y_w = w;
  defparam sat0.x_w = w+ws-12;

  // Saturation
  sat sat1(satIm, mulIm[w+ws-1:12]);
  defparam sat1.y_w = w;
  defparam sat1.x_w = w+ws-12;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      
      yOrR <= 0;
      yReR <= 0;
      yImR <= 0;
      
    // Normal operation
    end else begin
      
      yOrR <= xRe_re && xIm_re;
      yReR <= satRe;
      yImR <= satIm;

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

