//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   timeOff
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module timeOff(yRe, yRe_or, yRe_ff, yRe_we, 
               yIm, yIm_or, yIm_ff, yIm_we, 
               xRe, xRe_ir, xRe_fe, xRe_re, 
               xIm, xIm_ir, xIm_fe, xIm_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "firToff_0.v"
  `include "coeffToff_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign firToff_0_xRe             = xRe;
  assign firToff_0_xRe_fe          = xRe_fe;
  assign xRe_ir                    = firToff_0_xRe_ir;

  assign firToff_0_xIm             = xIm;
  assign firToff_0_xIm_fe          = xIm_fe;
  assign xIm_ir                    = firToff_0_xIm_ir;

  assign firToff_0_ioCtrl          = coeffToff_0_ioCtrl;
  assign firToff_0_ioCtrl_fe       = ~coeffToff_0_ioCtrl_or;
  assign coeffToff_0_ioCtrl_ff     = ~firToff_0_ioCtrl_ir;

  assign firToff_0_cf00            = coeffToff_0_cf00;
  assign firToff_0_cf00_fe         = ~coeffToff_0_cf00_or;
  assign coeffToff_0_cf00_ff       = ~firToff_0_cf00_ir;

  assign firToff_0_cf01            = coeffToff_0_cf01;
  assign firToff_0_cf01_fe         = ~coeffToff_0_cf01_or;
  assign coeffToff_0_cf01_ff       = ~firToff_0_cf01_ir;

  assign firToff_0_cf02            = coeffToff_0_cf02;
  assign firToff_0_cf02_fe         = ~coeffToff_0_cf02_or;
  assign coeffToff_0_cf02_ff       = ~firToff_0_cf02_ir;

  assign firToff_0_cf03            = coeffToff_0_cf03;
  assign firToff_0_cf03_fe         = ~coeffToff_0_cf03_or;
  assign coeffToff_0_cf03_ff       = ~firToff_0_cf03_ir;

  assign firToff_0_cf04            = coeffToff_0_cf04;
  assign firToff_0_cf04_fe         = ~coeffToff_0_cf04_or;
  assign coeffToff_0_cf04_ff       = ~firToff_0_cf04_ir;

  assign firToff_0_cf05            = coeffToff_0_cf05;
  assign firToff_0_cf05_fe         = ~coeffToff_0_cf05_or;
  assign coeffToff_0_cf05_ff       = ~firToff_0_cf05_ir;

  assign firToff_0_cf06            = coeffToff_0_cf06;
  assign firToff_0_cf06_fe         = ~coeffToff_0_cf06_or;
  assign coeffToff_0_cf06_ff       = ~firToff_0_cf06_ir;

  assign firToff_0_cf07            = coeffToff_0_cf07;
  assign firToff_0_cf07_fe         = ~coeffToff_0_cf07_or;
  assign coeffToff_0_cf07_ff       = ~firToff_0_cf07_ir;

  assign firToff_0_cf08            = coeffToff_0_cf08;
  assign firToff_0_cf08_fe         = ~coeffToff_0_cf08_or;
  assign coeffToff_0_cf08_ff       = ~firToff_0_cf08_ir;

  assign firToff_0_cf09            = coeffToff_0_cf09;
  assign firToff_0_cf09_fe         = ~coeffToff_0_cf09_or;
  assign coeffToff_0_cf09_ff       = ~firToff_0_cf09_ir;

  assign firToff_0_cf10            = coeffToff_0_cf10;
  assign firToff_0_cf10_fe         = ~coeffToff_0_cf10_or;
  assign coeffToff_0_cf10_ff       = ~firToff_0_cf10_ir;

  assign firToff_0_cf11            = coeffToff_0_cf11;
  assign firToff_0_cf11_fe         = ~coeffToff_0_cf11_or;
  assign coeffToff_0_cf11_ff       = ~firToff_0_cf11_ir;

  assign firToff_0_cf12            = coeffToff_0_cf12;
  assign firToff_0_cf12_fe         = ~coeffToff_0_cf12_or;
  assign coeffToff_0_cf12_ff       = ~firToff_0_cf12_ir;

  assign firToff_0_cf13            = coeffToff_0_cf13;
  assign firToff_0_cf13_fe         = ~coeffToff_0_cf13_or;
  assign coeffToff_0_cf13_ff       = ~firToff_0_cf13_ir;

  assign firToff_0_cf14            = coeffToff_0_cf14;
  assign firToff_0_cf14_fe         = ~coeffToff_0_cf14_or;
  assign coeffToff_0_cf14_ff       = ~firToff_0_cf14_ir;

  assign firToff_0_cf15            = coeffToff_0_cf15;
  assign firToff_0_cf15_fe         = ~coeffToff_0_cf15_or;
  assign coeffToff_0_cf15_ff       = ~firToff_0_cf15_ir;

  assign firToff_0_cf16            = coeffToff_0_cf16;
  assign firToff_0_cf16_fe         = ~coeffToff_0_cf16_or;
  assign coeffToff_0_cf16_ff       = ~firToff_0_cf16_ir;

  assign firToff_0_cf17            = coeffToff_0_cf17;
  assign firToff_0_cf17_fe         = ~coeffToff_0_cf17_or;
  assign coeffToff_0_cf17_ff       = ~firToff_0_cf17_ir;

  assign firToff_0_cf18            = coeffToff_0_cf18;
  assign firToff_0_cf18_fe         = ~coeffToff_0_cf18_or;
  assign coeffToff_0_cf18_ff       = ~firToff_0_cf18_ir;

  assign firToff_0_cf19            = coeffToff_0_cf19;
  assign firToff_0_cf19_fe         = ~coeffToff_0_cf19_or;
  assign coeffToff_0_cf19_ff       = ~firToff_0_cf19_ir;

  assign firToff_0_cf20            = coeffToff_0_cf20;
  assign firToff_0_cf20_fe         = ~coeffToff_0_cf20_or;
  assign coeffToff_0_cf20_ff       = ~firToff_0_cf20_ir;

  assign firToff_0_cf21            = coeffToff_0_cf21;
  assign firToff_0_cf21_fe         = ~coeffToff_0_cf21_or;
  assign coeffToff_0_cf21_ff       = ~firToff_0_cf21_ir;

  assign firToff_0_cf22            = coeffToff_0_cf22;
  assign firToff_0_cf22_fe         = ~coeffToff_0_cf22_or;
  assign coeffToff_0_cf22_ff       = ~firToff_0_cf22_ir;

  assign firToff_0_cf23            = coeffToff_0_cf23;
  assign firToff_0_cf23_fe         = ~coeffToff_0_cf23_or;
  assign coeffToff_0_cf23_ff       = ~firToff_0_cf23_ir;

  assign firToff_0_cf24            = coeffToff_0_cf24;
  assign firToff_0_cf24_fe         = ~coeffToff_0_cf24_or;
  assign coeffToff_0_cf24_ff       = ~firToff_0_cf24_ir;

  assign firToff_0_cf25            = coeffToff_0_cf25;
  assign firToff_0_cf25_fe         = ~coeffToff_0_cf25_or;
  assign coeffToff_0_cf25_ff       = ~firToff_0_cf25_ir;

  assign firToff_0_cf26            = coeffToff_0_cf26;
  assign firToff_0_cf26_fe         = ~coeffToff_0_cf26_or;
  assign coeffToff_0_cf26_ff       = ~firToff_0_cf26_ir;

  assign firToff_0_cf27            = coeffToff_0_cf27;
  assign firToff_0_cf27_fe         = ~coeffToff_0_cf27_or;
  assign coeffToff_0_cf27_ff       = ~firToff_0_cf27_ir;

  assign firToff_0_cf28            = coeffToff_0_cf28;
  assign firToff_0_cf28_fe         = ~coeffToff_0_cf28_or;
  assign coeffToff_0_cf28_ff       = ~firToff_0_cf28_ir;

  assign firToff_0_cf29            = coeffToff_0_cf29;
  assign firToff_0_cf29_fe         = ~coeffToff_0_cf29_or;
  assign coeffToff_0_cf29_ff       = ~firToff_0_cf29_ir;

  assign firToff_0_cf30            = coeffToff_0_cf30;
  assign firToff_0_cf30_fe         = ~coeffToff_0_cf30_or;
  assign coeffToff_0_cf30_ff       = ~firToff_0_cf30_ir;

  assign yRe                       = firToff_0_yRe;
  assign yRe_or                    = firToff_0_yRe_or;
  assign firToff_0_yRe_ff          = yRe_ff;

  assign yIm                       = firToff_0_yIm;
  assign yIm_or                    = firToff_0_yIm_or;
  assign firToff_0_yIm_ff          = yIm_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | firToff_0_regWe | coeffToff_0_regWe;
  assign regReOut = 0 | firToff_0_regRe | coeffToff_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================


endmodule
//=========================================================================================

