//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   shrRndSat
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module shrRndSat(yRe, yRe_or, yRe_ff, yRe_we, 
                 yIm, yIm_or, yIm_ff, yIm_we, 
                 xRe, xRe_ir, xRe_fe, xRe_re, 
                 xIm, xIm_ir, xIm_fe, xIm_re, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter sh                = 0;

  parameter yReR_w            = 0;
  parameter yReR_n            = 0;
  parameter yReR_m            = 0;
  parameter yImR_w            = 0;
  parameter yImR_n            = 0;
  parameter yImR_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg            [yReR_w-1:0]  yReR;
  reg            [yImR_w-1:0]  yImR;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire            x_re;
  wire    [wx:0]  addRe, addIm;
  wire  [wy-1:0]  ySatRe, ySatIm;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  assign x_re   = xRe_re & xIm_re;
  
  // --------------------------------------------------------------------------------------
  // Shift, round, saturate
  assign addRe = {xRe[wx-1], xRe} + (1 << (sh-1));
  assign addIm = {xIm[wx-1], xIm} + (1 << (sh-1));
  
  sat satRe(ySatRe, addRe[wx:sh]);
  defparam satRe.x_w = wx-sh+1;
  defparam satRe.y_w = wy;
  
  sat satIm(ySatIm, addIm[wx:sh]);
  defparam satIm.x_w = wx-sh+1;
  defparam satIm.y_w = wy;
  
  // --------------------------------------------------------------------------------------
  // Assign to register
  always @(posedge clk) begin
    if (run1_q == 0) begin
      yReR <= 0;
      yImR <= 0;
    end else begin
      if (x_re) begin
        yReR <= ySatRe;
        yImR <= ySatIm;
      end
    end
  end

  // --------------------------------------------------------------------------------------
  // Assign output
  assign yRe_or = x_re;
  assign yIm_or = x_re;

  assign yRe = yReR;
  assign yIm = yImR;
  
endmodule
//=========================================================================================

