//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   rfMain
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module rfMain(ctrlOut, ctrlOut_or, ctrlOut_ff, ctrlOut_we, 
              adcRe, adcRe_or, adcRe_ff, adcRe_we, 
              adcIm, adcIm_or, adcIm_ff, adcIm_we, 
              ctrlPhy0Out, ctrlPhy0Out_or, ctrlPhy0Out_ff, ctrlPhy0Out_we, 
              ctrlPhy1Out, ctrlPhy1Out_or, ctrlPhy1Out_ff, ctrlPhy1Out_we, 
              dataPhy0Tx, dataPhy0Tx_or, dataPhy0Tx_ff, dataPhy0Tx_we, 
              ctrlIn, ctrlIn_ir, ctrlIn_fe, ctrlIn_re, 
              dacRe, dacRe_ir, dacRe_fe, dacRe_re, 
              dacIm, dacIm_ir, dacIm_fe, dacIm_re, 
              ctrlPhy0In, ctrlPhy0In_ir, ctrlPhy0In_fe, ctrlPhy0In_re, 
              ctrlPhy1In, ctrlPhy1In_ir, ctrlPhy1In_fe, ctrlPhy1In_re, 
              dataPhy1Rx, dataPhy1Rx_ir, dataPhy1Rx_fe, dataPhy1Rx_re, 
              uartOut, 
              statLed, 
              resetOut, 
              gpo, 
              uartIn, 
              ctrlSel, 
              gainSel, 
              gpi, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_vrf.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter ctrlOut_w         = 0;
  parameter adcRe_w           = 0;
  parameter adcIm_w           = 0;
  parameter ctrlPhy0Out_w     = 0;
  parameter ctrlPhy1Out_w     = 0;
  parameter dataPhy0Tx_w      = 0;
  parameter ctrlIn_w          = 0;
  parameter dacRe_w           = 0;
  parameter dacIm_w           = 0;
  parameter ctrlPhy0In_w      = 0;
  parameter ctrlPhy1In_w      = 0;
  parameter dataPhy1Rx_w      = 0;

  parameter uartOut_w         = 0;
  parameter statLed_w         = 0;
  parameter resetOut_w        = 0;
  parameter gpo_w             = 0;
  parameter uartIn_w          = 0;
  parameter ctrlSel_w         = 0;
  parameter gainSel_w         = 0;
  parameter gpi_w             = 0;

  parameter resetReg_w        = 0;
  parameter resetReg_r        = 0;
  parameter resetReg_s        = 0;
  parameter R_resetReg        = 0;
  parameter gpoR_w            = 0;
  parameter gpoR_r            = 0;
  parameter gpoR_s            = 0;
  parameter R_gpoR            = 0;
  parameter gpiR_w            = 0;
  parameter gpiR_r            = 0;
  parameter gpiR_s            = 0;
  parameter R_gpiR            = 0;
  parameter stat_w            = 0;
  parameter stat_r            = 0;
  parameter stat_s            = 0;
  parameter R_stat            = 0;

  parameter w                 = 0;
  parameter wd                = 0;

  parameter extIf2Host_w      = 0;
  parameter extIf2Host_n      = 0;
  parameter extIf2Host_m      = 0;
  parameter R_extIf2Host      = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output      [ctrlOut_w-1:0]  ctrlOut;
  output                       ctrlOut_or;
  input                        ctrlOut_ff;
  output                       ctrlOut_we;
  assign                       ctrlOut_we = ctrlOut_or & ~ctrlOut_ff;

  output        [adcRe_w-1:0]  adcRe;
  output                       adcRe_or;
  input                        adcRe_ff;
  output                       adcRe_we;
  assign                       adcRe_we = adcRe_or & ~adcRe_ff;

  output        [adcIm_w-1:0]  adcIm;
  output                       adcIm_or;
  input                        adcIm_ff;
  output                       adcIm_we;
  assign                       adcIm_we = adcIm_or & ~adcIm_ff;

  output  [ctrlPhy0Out_w-1:0]  ctrlPhy0Out;
  output                       ctrlPhy0Out_or;
  input                        ctrlPhy0Out_ff;
  output                       ctrlPhy0Out_we;
  assign                       ctrlPhy0Out_we = ctrlPhy0Out_or & ~ctrlPhy0Out_ff;

  output  [ctrlPhy1Out_w-1:0]  ctrlPhy1Out;
  output                       ctrlPhy1Out_or;
  input                        ctrlPhy1Out_ff;
  output                       ctrlPhy1Out_we;
  assign                       ctrlPhy1Out_we = ctrlPhy1Out_or & ~ctrlPhy1Out_ff;

  output   [dataPhy0Tx_w-1:0]  dataPhy0Tx;
  output                       dataPhy0Tx_or;
  input                        dataPhy0Tx_ff;
  output                       dataPhy0Tx_we;
  assign                       dataPhy0Tx_we = dataPhy0Tx_or & ~dataPhy0Tx_ff;

  input        [ctrlIn_w-1:0]  ctrlIn;
  output                       ctrlIn_ir;
  input                        ctrlIn_fe;
  output                       ctrlIn_re;
  assign                       ctrlIn_re = ctrlIn_ir & ~ctrlIn_fe;

  input         [dacRe_w-1:0]  dacRe;
  output                       dacRe_ir;
  input                        dacRe_fe;
  output                       dacRe_re;
  assign                       dacRe_re = dacRe_ir & ~dacRe_fe;

  input         [dacIm_w-1:0]  dacIm;
  output                       dacIm_ir;
  input                        dacIm_fe;
  output                       dacIm_re;
  assign                       dacIm_re = dacIm_ir & ~dacIm_fe;

  input    [ctrlPhy0In_w-1:0]  ctrlPhy0In;
  output                       ctrlPhy0In_ir;
  input                        ctrlPhy0In_fe;
  output                       ctrlPhy0In_re;
  assign                       ctrlPhy0In_re = ctrlPhy0In_ir & ~ctrlPhy0In_fe;

  input    [ctrlPhy1In_w-1:0]  ctrlPhy1In;
  output                       ctrlPhy1In_ir;
  input                        ctrlPhy1In_fe;
  output                       ctrlPhy1In_re;
  assign                       ctrlPhy1In_re = ctrlPhy1In_ir & ~ctrlPhy1In_fe;

  input    [dataPhy1Rx_w-1:0]  dataPhy1Rx;
  output                       dataPhy1Rx_ir;
  input                        dataPhy1Rx_fe;
  output                       dataPhy1Rx_re;
  assign                       dataPhy1Rx_re = dataPhy1Rx_ir & ~dataPhy1Rx_fe;

  output      [uartOut_w-1:0]  uartOut;
  output      [statLed_w-1:0]  statLed;
  output     [resetOut_w-1:0]  resetOut;
  output          [gpo_w-1:0]  gpo;
  input        [uartIn_w-1:0]  uartIn;
  input       [ctrlSel_w-1:0]  ctrlSel;
  input       [gainSel_w-1:0]  gainSel;
  input           [gpi_w-1:0]  gpi;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire       [resetReg_w-1:0]  resetReg_q;
  wire       [resetReg_w-1:0]  resetReg_d;
  wire                         resetReg_weint;
  assign                       resetReg_weint = 0;

  wire           [gpoR_w-1:0]  gpoR_q;
  wire           [gpoR_w-1:0]  gpoR_d;
  wire                         gpoR_weint;
  assign                       gpoR_weint = 0;

  wire           [gpiR_w-1:0]  gpiR_q;
  wire           [gpiR_w-1:0]  gpiR_d;
  wire                         gpiR_weint;

  wire           [stat_w-1:0]  stat_q;
  wire           [stat_w-1:0]  stat_d;
  wire                         stat_weint;
  assign                       stat_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg resetReg(resetReg_q, regBus, resetReg_d, resetReg_weint, regWe, regRe, clk, reset);
  defparam resetReg.w    = resetReg_w;
  defparam resetReg.rval = resetReg_r;
  defparam resetReg.sgn  = resetReg_s;
  defparam resetReg.adr  = R_resetReg;

  ereg gpoR(gpoR_q, regBus, gpoR_d, gpoR_weint, regWe, regRe, clk, reset);
  defparam gpoR.w    = gpoR_w;
  defparam gpoR.rval = gpoR_r;
  defparam gpoR.sgn  = gpoR_s;
  defparam gpoR.adr  = R_gpoR;

  ereg gpiR(gpiR_q, regBus, gpiR_d, gpiR_weint, regWe, regRe, clk, reset);
  defparam gpiR.w    = gpiR_w;
  defparam gpiR.rval = gpiR_r;
  defparam gpiR.sgn  = gpiR_s;
  defparam gpiR.adr  = R_gpiR;

  ereg stat(stat_q, regBus, stat_d, stat_weint, regWe, regRe, clk, reset);
  defparam stat.w    = stat_w;
  defparam stat.rval = stat_r;
  defparam stat.sgn  = stat_s;
  defparam stat.adr  = R_stat;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "uart16_vrf.v"
  `include "extIf_0.v"
  `include "irqCtrl_rf.v"
  `include "s1To2Sel_16.v"
  `include "s2To1Sel_16.v"
  `include "X16_rf.v"
  `include "rfAll_0.v"
  `include "extIf_phy0.v"
  `include "extIf_phy1.v"
  `include "datSrc_0.v"
  `include "c8To16_0.v"
  `include "dataBuf_phy0.v"
  `include "dataBuf_phy1.v"
  `include "c16To8_0.v"
  `include "datSnk_0.v"
  `include "timer_0.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo extIf_0_tx -> s1To2Sel_16_x
  wire   [extIf2Host_w-1:0]  extIf2Host_q;
  wire                       extIf2Host_fe;
  wire                       extIf2Host_ff;
  wire                       extIf2Host_ff2;
  wire                       extIf2Host_fuf;
  wire                       extIf2Host_fof;
  wire   [extIf2Host_w-1:0]  extIf2Host_d;
  wire                       extIf2Host_re;
  wire                       extIf2Host_we;
  wire                       extIf2Host_ir;
  wire                       extIf2Host_or;
  wire                       extIf2Host_rst;

  fifoB extIf2Host(extIf2Host_q, extIf2Host_fe, extIf2Host_ff, extIf2Host_ff2, extIf2Host_fuf,
                   extIf2Host_fof, extIf2Host_d, extIf2Host_re, extIf2Host_we, extIf2Host_ir,
                   extIf2Host_or, extIf2Host_rst, clk);
  defparam extIf2Host.w = extIf2Host_w;
  defparam extIf2Host.m = extIf2Host_m;
  defparam extIf2Host.n = extIf2Host_n;
  defparam extIf2Host.a = R_extIf2Host;

  assign extIf2Host_d              = extIf_0_tx;
  assign extIf2Host_we             = extIf_0_tx_we;
  assign extIf_0_tx_ff             = extIf2Host_ff;
  assign extIf2Host_or             = extIf_0_tx_or;

  assign s1To2Sel_16_x             = extIf2Host_q;
  assign s1To2Sel_16_x_fe          = extIf2Host_fe;
  assign extIf2Host_re             = s1To2Sel_16_x_re;
  assign extIf2Host_ir             = s1To2Sel_16_x_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign s2To1Sel_16_sel           = ctrlSel;
  assign s2To1Sel_16_x0            = ctrlIn;
  assign s2To1Sel_16_x0_fe         = ctrlIn_fe;
  assign ctrlIn_ir                 = s2To1Sel_16_x0_ir;

  assign s2To1Sel_16_x1            = uart16_vrf_rxExtIf;
  assign s2To1Sel_16_x1_fe         = ~uart16_vrf_rxExtIf_or;
  assign uart16_vrf_rxExtIf_ff     = ~s2To1Sel_16_x1_ir;

  assign extIf_0_rx                = s2To1Sel_16_y;
  assign extIf_0_rx_fe             = ~s2To1Sel_16_y_or;
  assign s2To1Sel_16_y_ff          = ~extIf_0_rx_ir;

  assign s1To2Sel_16_sel           = ctrlSel;
  assign ctrlOut                   = s1To2Sel_16_y0;
  assign ctrlOut_or                = s1To2Sel_16_y0_or;
  assign s1To2Sel_16_y0_ff         = ctrlOut_ff;

  assign uart16_vrf_txExtIf        = s1To2Sel_16_y1;
  assign uart16_vrf_txExtIf_fe     = ~s1To2Sel_16_y1_or;
  assign s1To2Sel_16_y1_ff         = ~uart16_vrf_txExtIf_ir;

  assign uart16_vrf_rxs            = uartIn;
  assign uartOut                   = uart16_vrf_txs;
  assign rfAll_0_xRe               = dacRe;
  assign rfAll_0_xRe_fe            = dacRe_fe;
  assign dacRe_ir                  = rfAll_0_xRe_ir;

  assign rfAll_0_xIm               = dacIm;
  assign rfAll_0_xIm_fe            = dacIm_fe;
  assign dacIm_ir                  = rfAll_0_xIm_ir;

  assign adcRe                     = rfAll_0_yRe;
  assign adcRe_or                  = rfAll_0_yRe_or;
  assign rfAll_0_yRe_ff            = adcRe_ff;

  assign adcIm                     = rfAll_0_yIm;
  assign adcIm_or                  = rfAll_0_yIm_or;
  assign rfAll_0_yIm_ff            = adcIm_ff;

  assign extIf_phy0_rx             = ctrlPhy0In;
  assign extIf_phy0_rx_fe          = ctrlPhy0In_fe;
  assign ctrlPhy0In_ir             = extIf_phy0_rx_ir;

  assign ctrlPhy0Out               = extIf_phy0_tx;
  assign ctrlPhy0Out_or            = extIf_phy0_tx_or;
  assign extIf_phy0_tx_ff          = ctrlPhy0Out_ff;

  assign extIf_phy1_rx             = ctrlPhy1In;
  assign extIf_phy1_rx_fe          = ctrlPhy1In_fe;
  assign ctrlPhy1In_ir             = extIf_phy1_rx_ir;

  assign ctrlPhy1Out               = extIf_phy1_tx;
  assign ctrlPhy1Out_or            = extIf_phy1_tx_or;
  assign extIf_phy1_tx_ff          = ctrlPhy1Out_ff;

  assign c8To16_0_x                = datSrc_0_y;
  assign c8To16_0_x_fe             = ~datSrc_0_y_or;
  assign datSrc_0_y_ff             = ~c8To16_0_x_ir;

  assign dataBuf_phy0_x            = c8To16_0_y;
  assign dataBuf_phy0_x_fe         = ~c8To16_0_y_or;
  assign c8To16_0_y_ff             = ~dataBuf_phy0_x_ir;

  assign dataPhy0Tx                = dataBuf_phy0_y;
  assign dataPhy0Tx_or             = dataBuf_phy0_y_or;
  assign dataBuf_phy0_y_ff         = dataPhy0Tx_ff;

  assign dataBuf_phy1_x            = dataPhy1Rx;
  assign dataBuf_phy1_x_fe         = dataPhy1Rx_fe;
  assign dataPhy1Rx_ir             = dataBuf_phy1_x_ir;

  assign c16To8_0_x                = dataBuf_phy1_y;
  assign c16To8_0_x_fe             = ~dataBuf_phy1_y_or;
  assign dataBuf_phy1_y_ff         = ~c16To8_0_x_ir;

  assign datSnk_0_x                = c16To8_0_y;
  assign datSnk_0_x_fe             = ~c16To8_0_y_or;
  assign c16To8_0_y_ff             = ~datSnk_0_x_ir;

  assign rfAll_0_gainSel           = gainSel;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | uart16_vrf_regWe | extIf_0_regWe | irqCtrl_rf_regWe
                      | s1To2Sel_16_regWe | s2To1Sel_16_regWe | X16_rf_regWe
                      | rfAll_0_regWe | extIf_phy0_regWe | extIf_phy1_regWe
                      | datSrc_0_regWe | c8To16_0_regWe | dataBuf_phy0_regWe
                      | dataBuf_phy1_regWe | c16To8_0_regWe | datSnk_0_regWe
                      | timer_0_regWe;
  assign regReOut = 0 | uart16_vrf_regRe | extIf_0_regRe | irqCtrl_rf_regRe
                      | s1To2Sel_16_regRe | s2To1Sel_16_regRe | X16_rf_regRe
                      | rfAll_0_regRe | extIf_phy0_regRe | extIf_phy1_regRe
                      | datSrc_0_regRe | c8To16_0_regRe | dataBuf_phy0_regRe
                      | dataBuf_phy1_regRe | c16To8_0_regRe | datSnk_0_regRe
                      | timer_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Assign reset output
  assign resetOut                   = extIf_0_resetOut | resetReg_q;
  
  // ExtIf output FIFO reset
  assign extIf2Host_rst             = reset;
  
  // External X16-IRQ
  assign X16_rf_irqExt                          = irqCtrl_rf_irqOut;
  assign irqCtrl_rf_irqIn[VrfIrqBitExtIfRx_C]   = extIf_0_irqRx;
  assign irqCtrl_rf_irqIn[VrfIrqBitExtIfTx_C]   = extIf_0_irqTx;
  assign irqCtrl_rf_irqIn[VrfIrqBitExtIf0Rx_C]  = extIf_phy0_irqRx;
  assign irqCtrl_rf_irqIn[VrfIrqBitExtIf0Tx_C]  = extIf_phy0_irqTx;
  assign irqCtrl_rf_irqIn[VrfIrqBitExtIf1Rx_C]  = extIf_phy1_irqRx;
  assign irqCtrl_rf_irqIn[VrfIrqBitExtIf1Tx_C]  = extIf_phy1_irqTx;

  // Connect RF control signals
//  assign paOn                       = txRfCtrl_0_paOn;
//  assign txOn                       = txRfCtrl_0_txOn;
//  assign rxOn                       = rxRfCtrl_q;

  // Connect GPIOs
  assign gpo                        = gpoR_q;   // Ereg  -> output
  assign gpiR_d                     = gpi;      // Input -> Ereg
  assign gpiR_weint                 = 1;        //  => always enable
  
  // Test LED
  assign statLed = stat_q;

//----------------------------------------------------------------------------------------

endmodule
//=========================================================================================

