//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   rfAll
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module rfAll(yRe, yRe_or, yRe_ff, yRe_we, 
             yIm, yIm_or, yIm_ff, yIm_we, 
             xRe, xRe_ir, xRe_fe, xRe_re, 
             xIm, xIm_ir, xIm_fe, xIm_re, 
             gainSel, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;

  parameter gainSel_w         = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wg                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input       [gainSel_w-1:0]  gainSel;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "mainTx_0.v"
  `include "mainChan_0.v"
  `include "mainRx_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign mainTx_0_xRe              = xRe;
  assign mainTx_0_xRe_fe           = xRe_fe;
  assign xRe_ir                    = mainTx_0_xRe_ir;

  assign mainTx_0_xIm              = xIm;
  assign mainTx_0_xIm_fe           = xIm_fe;
  assign xIm_ir                    = mainTx_0_xIm_ir;

  assign mainChan_0_xRe            = mainTx_0_yRe;
  assign mainChan_0_xRe_fe         = ~mainTx_0_yRe_or;
  assign mainTx_0_yRe_ff           = ~mainChan_0_xRe_ir;

  assign mainChan_0_xIm            = mainTx_0_yIm;
  assign mainChan_0_xIm_fe         = ~mainTx_0_yIm_or;
  assign mainTx_0_yIm_ff           = ~mainChan_0_xIm_ir;

  assign mainRx_0_xRe              = mainChan_0_yRe;
  assign mainRx_0_xRe_fe           = ~mainChan_0_yRe_or;
  assign mainChan_0_yRe_ff         = ~mainRx_0_xRe_ir;

  assign mainRx_0_xIm              = mainChan_0_yIm;
  assign mainRx_0_xIm_fe           = ~mainChan_0_yIm_or;
  assign mainChan_0_yIm_ff         = ~mainRx_0_xIm_ir;

  assign yRe                       = mainRx_0_yRe;
  assign yRe_or                    = mainRx_0_yRe_or;
  assign mainRx_0_yRe_ff           = yRe_ff;

  assign yIm                       = mainRx_0_yIm;
  assign yIm_or                    = mainRx_0_yIm_or;
  assign mainRx_0_yIm_ff           = yIm_ff;

  assign mainRx_0_gainSel          = gainSel;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | mainTx_0_regWe | mainChan_0_regWe | mainRx_0_regWe;
  assign regReOut = 0 | mainTx_0_regRe | mainChan_0_regRe | mainRx_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================


endmodule
//=========================================================================================

