//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   pa
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module pa(yRe, yRe_or, yRe_ff, yRe_we, 
          yIm, yIm_or, yIm_ff, yIm_we, 
          xRe, xRe_ir, xRe_fe, xRe_re, 
          xIm, xIm_ir, xIm_fe, xIm_re, 
          regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter bypass_w          = 0;
  parameter bypass_r          = 0;
  parameter bypass_s          = 0;
  parameter R_bypass          = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire         [bypass_w-1:0]  bypass_q;
  wire         [bypass_w-1:0]  bypass_d;
  wire                         bypass_weint;
  assign                       bypass_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg bypass(bypass_q, regBus, bypass_d, bypass_weint, regWe, regRe, clk, reset);
  defparam bypass.w    = bypass_w;
  defparam bypass.rval = bypass_r;
  defparam bypass.sgn  = bypass_s;
  defparam bypass.adr  = R_bypass;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "crdcAbs_0.v"
  `include "linInt_amp.v"
  `include "linInt_ph.v"
  `include "crdcPhRot_0.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | crdcAbs_0_regWe | linInt_amp_regWe | linInt_ph_regWe
                      | crdcPhRot_0_regWe;
  assign regReOut = 0 | crdcAbs_0_regRe | linInt_amp_regRe | linInt_ph_regRe
                      | crdcPhRot_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  assign yRe_or = xRe_re;
  assign yIm_or = xIm_re;
  assign yRe    = xRe;
  assign yIm    = xIm;
  
endmodule
//=========================================================================================

