//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   multiPath
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module multiPath(yRe, yRe_or, yRe_ff, yRe_we, 
                 yIm, yIm_or, yIm_ff, yIm_we, 
                 xRe, xRe_ir, xRe_fe, xRe_re, 
                 xIm, xIm_ir, xIm_fe, xIm_re, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;
  parameter nc                = 0;
  parameter nd                = 0;

  parameter xRePlIm_w         = 0;
  parameter xRePlIm_fe_w      = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Wires defined for various purposes
  wire        [xRePlIm_w-1:0]  xRePlIm;
  wire     [xRePlIm_fe_w-1:0]  xRePlIm_fe;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "firCxMul_00.v"
  `include "firCxMul_01.v"
  `include "firCxMul_02.v"
  `include "firCxMul_03.v"
  `include "firCxMul_04.v"
  `include "firCxMul_05.v"
  `include "firCxMul_06.v"
  `include "firCxMul_07.v"
  `include "firCxMul_08.v"
  `include "firCxMul_09.v"
  `include "firMuxAdd_00.v"
  `include "firMuxAdd_01.v"
  `include "firMuxAdd_02.v"
  `include "firMuxAdd_03.v"
  `include "firMuxAdd_04.v"
  `include "firMuxAdd_05.v"
  `include "firMuxAdd_06.v"
  `include "firMuxAdd_07.v"
  `include "firMuxAdd_08.v"
  `include "firMuxAdd_09.v"
  `include "firMuxAdd_10.v"
  `include "firMuxAdd_11.v"
  `include "firMuxAdd_12.v"
  `include "firMuxAdd_13.v"
  `include "firMuxAdd_14.v"
  `include "firMuxAdd_15.v"
  `include "firMuxAdd_16.v"
  `include "firMuxAdd_17.v"
  `include "firMuxAdd_18.v"
  `include "firMuxAdd_19.v"
  `include "firMuxAdd_20.v"
  `include "firMuxAdd_21.v"
  `include "firMuxAdd_22.v"
  `include "firMuxAdd_23.v"
  `include "firMuxAdd_24.v"
  `include "firMuxAdd_25.v"
  `include "firMuxAdd_26.v"
  `include "firMuxAdd_27.v"
  `include "firMuxAdd_28.v"
  `include "firMuxAdd_29.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign firCxMul_00_run1          = run1_q;
  assign firCxMul_01_run1          = run1_q;
  assign firCxMul_02_run1          = run1_q;
  assign firCxMul_03_run1          = run1_q;
  assign firCxMul_04_run1          = run1_q;
  assign firCxMul_05_run1          = run1_q;
  assign firCxMul_06_run1          = run1_q;
  assign firCxMul_07_run1          = run1_q;
  assign firCxMul_08_run1          = run1_q;
  assign firCxMul_09_run1          = run1_q;
  assign firMuxAdd_00_run1         = run1_q;
  assign firMuxAdd_01_run1         = run1_q;
  assign firMuxAdd_02_run1         = run1_q;
  assign firMuxAdd_03_run1         = run1_q;
  assign firMuxAdd_04_run1         = run1_q;
  assign firMuxAdd_05_run1         = run1_q;
  assign firMuxAdd_06_run1         = run1_q;
  assign firMuxAdd_07_run1         = run1_q;
  assign firMuxAdd_08_run1         = run1_q;
  assign firMuxAdd_09_run1         = run1_q;
  assign firMuxAdd_10_run1         = run1_q;
  assign firMuxAdd_11_run1         = run1_q;
  assign firMuxAdd_12_run1         = run1_q;
  assign firMuxAdd_13_run1         = run1_q;
  assign firMuxAdd_14_run1         = run1_q;
  assign firMuxAdd_15_run1         = run1_q;
  assign firMuxAdd_16_run1         = run1_q;
  assign firMuxAdd_17_run1         = run1_q;
  assign firMuxAdd_18_run1         = run1_q;
  assign firMuxAdd_19_run1         = run1_q;
  assign firMuxAdd_20_run1         = run1_q;
  assign firMuxAdd_21_run1         = run1_q;
  assign firMuxAdd_22_run1         = run1_q;
  assign firMuxAdd_23_run1         = run1_q;
  assign firMuxAdd_24_run1         = run1_q;
  assign firMuxAdd_25_run1         = run1_q;
  assign firMuxAdd_26_run1         = run1_q;
  assign firMuxAdd_27_run1         = run1_q;
  assign firMuxAdd_28_run1         = run1_q;
  assign firMuxAdd_29_run1         = run1_q;
  assign firMuxAdd_00_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_00_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_01_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_01_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_02_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_02_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_03_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_03_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_04_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_04_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_05_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_05_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_06_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_06_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_07_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_07_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_08_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_08_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_09_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_09_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_10_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_10_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_11_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_11_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_12_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_12_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_13_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_13_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_14_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_14_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_15_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_15_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_16_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_16_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_17_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_17_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_18_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_18_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_19_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_19_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_20_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_20_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_21_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_21_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_22_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_22_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_23_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_23_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_24_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_24_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_25_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_25_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_26_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_26_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_27_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_27_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_28_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_28_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_29_xM00Re       = firCxMul_00_yRe;
  assign firMuxAdd_29_xM00Im       = firCxMul_00_yIm;
  assign firMuxAdd_00_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_00_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_01_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_01_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_02_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_02_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_03_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_03_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_04_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_04_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_05_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_05_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_06_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_06_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_07_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_07_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_08_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_08_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_09_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_09_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_10_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_10_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_11_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_11_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_12_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_12_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_13_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_13_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_14_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_14_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_15_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_15_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_16_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_16_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_17_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_17_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_18_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_18_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_19_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_19_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_20_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_20_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_21_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_21_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_22_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_22_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_23_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_23_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_24_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_24_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_25_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_25_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_26_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_26_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_27_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_27_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_28_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_28_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_29_xM01Re       = firCxMul_01_yRe;
  assign firMuxAdd_29_xM01Im       = firCxMul_01_yIm;
  assign firMuxAdd_00_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_00_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_01_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_01_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_02_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_02_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_03_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_03_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_04_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_04_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_05_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_05_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_06_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_06_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_07_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_07_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_08_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_08_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_09_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_09_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_10_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_10_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_11_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_11_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_12_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_12_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_13_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_13_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_14_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_14_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_15_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_15_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_16_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_16_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_17_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_17_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_18_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_18_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_19_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_19_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_20_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_20_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_21_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_21_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_22_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_22_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_23_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_23_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_24_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_24_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_25_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_25_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_26_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_26_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_27_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_27_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_28_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_28_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_29_xM02Re       = firCxMul_02_yRe;
  assign firMuxAdd_29_xM02Im       = firCxMul_02_yIm;
  assign firMuxAdd_00_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_00_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_01_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_01_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_02_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_02_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_03_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_03_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_04_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_04_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_05_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_05_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_06_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_06_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_07_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_07_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_08_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_08_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_09_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_09_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_10_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_10_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_11_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_11_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_12_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_12_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_13_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_13_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_14_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_14_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_15_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_15_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_16_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_16_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_17_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_17_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_18_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_18_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_19_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_19_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_20_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_20_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_21_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_21_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_22_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_22_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_23_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_23_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_24_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_24_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_25_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_25_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_26_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_26_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_27_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_27_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_28_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_28_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_29_xM03Re       = firCxMul_03_yRe;
  assign firMuxAdd_29_xM03Im       = firCxMul_03_yIm;
  assign firMuxAdd_00_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_00_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_01_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_01_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_02_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_02_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_03_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_03_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_04_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_04_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_05_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_05_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_06_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_06_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_07_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_07_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_08_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_08_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_09_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_09_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_10_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_10_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_11_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_11_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_12_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_12_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_13_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_13_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_14_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_14_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_15_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_15_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_16_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_16_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_17_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_17_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_18_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_18_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_19_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_19_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_20_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_20_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_21_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_21_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_22_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_22_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_23_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_23_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_24_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_24_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_25_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_25_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_26_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_26_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_27_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_27_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_28_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_28_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_29_xM04Re       = firCxMul_04_yRe;
  assign firMuxAdd_29_xM04Im       = firCxMul_04_yIm;
  assign firMuxAdd_00_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_00_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_01_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_01_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_02_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_02_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_03_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_03_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_04_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_04_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_05_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_05_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_06_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_06_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_07_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_07_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_08_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_08_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_09_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_09_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_10_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_10_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_11_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_11_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_12_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_12_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_13_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_13_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_14_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_14_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_15_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_15_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_16_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_16_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_17_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_17_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_18_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_18_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_19_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_19_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_20_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_20_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_21_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_21_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_22_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_22_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_23_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_23_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_24_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_24_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_25_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_25_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_26_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_26_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_27_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_27_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_28_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_28_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_29_xM05Re       = firCxMul_05_yRe;
  assign firMuxAdd_29_xM05Im       = firCxMul_05_yIm;
  assign firMuxAdd_00_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_00_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_01_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_01_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_02_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_02_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_03_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_03_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_04_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_04_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_05_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_05_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_06_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_06_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_07_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_07_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_08_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_08_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_09_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_09_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_10_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_10_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_11_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_11_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_12_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_12_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_13_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_13_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_14_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_14_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_15_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_15_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_16_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_16_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_17_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_17_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_18_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_18_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_19_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_19_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_20_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_20_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_21_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_21_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_22_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_22_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_23_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_23_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_24_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_24_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_25_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_25_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_26_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_26_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_27_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_27_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_28_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_28_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_29_xM06Re       = firCxMul_06_yRe;
  assign firMuxAdd_29_xM06Im       = firCxMul_06_yIm;
  assign firMuxAdd_00_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_00_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_01_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_01_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_02_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_02_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_03_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_03_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_04_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_04_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_05_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_05_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_06_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_06_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_07_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_07_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_08_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_08_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_09_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_09_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_10_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_10_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_11_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_11_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_12_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_12_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_13_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_13_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_14_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_14_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_15_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_15_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_16_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_16_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_17_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_17_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_18_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_18_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_19_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_19_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_20_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_20_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_21_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_21_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_22_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_22_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_23_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_23_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_24_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_24_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_25_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_25_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_26_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_26_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_27_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_27_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_28_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_28_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_29_xM07Re       = firCxMul_07_yRe;
  assign firMuxAdd_29_xM07Im       = firCxMul_07_yIm;
  assign firMuxAdd_00_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_00_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_01_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_01_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_02_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_02_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_03_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_03_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_04_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_04_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_05_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_05_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_06_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_06_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_07_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_07_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_08_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_08_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_09_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_09_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_10_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_10_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_11_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_11_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_12_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_12_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_13_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_13_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_14_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_14_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_15_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_15_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_16_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_16_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_17_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_17_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_18_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_18_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_19_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_19_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_20_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_20_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_21_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_21_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_22_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_22_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_23_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_23_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_24_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_24_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_25_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_25_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_26_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_26_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_27_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_27_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_28_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_28_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_29_xM08Re       = firCxMul_08_yRe;
  assign firMuxAdd_29_xM08Im       = firCxMul_08_yIm;
  assign firMuxAdd_00_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_00_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_01_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_01_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_02_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_02_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_03_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_03_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_04_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_04_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_05_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_05_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_06_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_06_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_07_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_07_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_08_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_08_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_09_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_09_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_10_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_10_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_11_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_11_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_12_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_12_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_13_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_13_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_14_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_14_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_15_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_15_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_16_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_16_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_17_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_17_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_18_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_18_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_19_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_19_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_20_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_20_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_21_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_21_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_22_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_22_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_23_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_23_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_24_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_24_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_25_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_25_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_26_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_26_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_27_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_27_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_28_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_28_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_29_xM09Re       = firCxMul_09_yRe;
  assign firMuxAdd_29_xM09Im       = firCxMul_09_yIm;
  assign firMuxAdd_29_xRe          = 0;
  assign firMuxAdd_29_xRe_fe       = xRe_fe;
  assign firMuxAdd_29_xIm          = 0;
  assign firMuxAdd_29_xIm_fe       = xIm_fe;
  assign firMuxAdd_28_xRe          = firMuxAdd_29_yRe;
  assign firMuxAdd_28_xRe_fe       = ~firMuxAdd_29_yRe_or;
  assign firMuxAdd_29_yRe_ff       = ~firMuxAdd_28_xRe_ir;

  assign firMuxAdd_28_xIm          = firMuxAdd_29_yIm;
  assign firMuxAdd_28_xIm_fe       = ~firMuxAdd_29_yIm_or;
  assign firMuxAdd_29_yIm_ff       = ~firMuxAdd_28_xIm_ir;

  assign firMuxAdd_27_xRe          = firMuxAdd_28_yRe;
  assign firMuxAdd_27_xRe_fe       = ~firMuxAdd_28_yRe_or;
  assign firMuxAdd_28_yRe_ff       = ~firMuxAdd_27_xRe_ir;

  assign firMuxAdd_27_xIm          = firMuxAdd_28_yIm;
  assign firMuxAdd_27_xIm_fe       = ~firMuxAdd_28_yIm_or;
  assign firMuxAdd_28_yIm_ff       = ~firMuxAdd_27_xIm_ir;

  assign firMuxAdd_26_xRe          = firMuxAdd_27_yRe;
  assign firMuxAdd_26_xRe_fe       = ~firMuxAdd_27_yRe_or;
  assign firMuxAdd_27_yRe_ff       = ~firMuxAdd_26_xRe_ir;

  assign firMuxAdd_26_xIm          = firMuxAdd_27_yIm;
  assign firMuxAdd_26_xIm_fe       = ~firMuxAdd_27_yIm_or;
  assign firMuxAdd_27_yIm_ff       = ~firMuxAdd_26_xIm_ir;

  assign firMuxAdd_25_xRe          = firMuxAdd_26_yRe;
  assign firMuxAdd_25_xRe_fe       = ~firMuxAdd_26_yRe_or;
  assign firMuxAdd_26_yRe_ff       = ~firMuxAdd_25_xRe_ir;

  assign firMuxAdd_25_xIm          = firMuxAdd_26_yIm;
  assign firMuxAdd_25_xIm_fe       = ~firMuxAdd_26_yIm_or;
  assign firMuxAdd_26_yIm_ff       = ~firMuxAdd_25_xIm_ir;

  assign firMuxAdd_24_xRe          = firMuxAdd_25_yRe;
  assign firMuxAdd_24_xRe_fe       = ~firMuxAdd_25_yRe_or;
  assign firMuxAdd_25_yRe_ff       = ~firMuxAdd_24_xRe_ir;

  assign firMuxAdd_24_xIm          = firMuxAdd_25_yIm;
  assign firMuxAdd_24_xIm_fe       = ~firMuxAdd_25_yIm_or;
  assign firMuxAdd_25_yIm_ff       = ~firMuxAdd_24_xIm_ir;

  assign firMuxAdd_23_xRe          = firMuxAdd_24_yRe;
  assign firMuxAdd_23_xRe_fe       = ~firMuxAdd_24_yRe_or;
  assign firMuxAdd_24_yRe_ff       = ~firMuxAdd_23_xRe_ir;

  assign firMuxAdd_23_xIm          = firMuxAdd_24_yIm;
  assign firMuxAdd_23_xIm_fe       = ~firMuxAdd_24_yIm_or;
  assign firMuxAdd_24_yIm_ff       = ~firMuxAdd_23_xIm_ir;

  assign firMuxAdd_22_xRe          = firMuxAdd_23_yRe;
  assign firMuxAdd_22_xRe_fe       = ~firMuxAdd_23_yRe_or;
  assign firMuxAdd_23_yRe_ff       = ~firMuxAdd_22_xRe_ir;

  assign firMuxAdd_22_xIm          = firMuxAdd_23_yIm;
  assign firMuxAdd_22_xIm_fe       = ~firMuxAdd_23_yIm_or;
  assign firMuxAdd_23_yIm_ff       = ~firMuxAdd_22_xIm_ir;

  assign firMuxAdd_21_xRe          = firMuxAdd_22_yRe;
  assign firMuxAdd_21_xRe_fe       = ~firMuxAdd_22_yRe_or;
  assign firMuxAdd_22_yRe_ff       = ~firMuxAdd_21_xRe_ir;

  assign firMuxAdd_21_xIm          = firMuxAdd_22_yIm;
  assign firMuxAdd_21_xIm_fe       = ~firMuxAdd_22_yIm_or;
  assign firMuxAdd_22_yIm_ff       = ~firMuxAdd_21_xIm_ir;

  assign firMuxAdd_20_xRe          = firMuxAdd_21_yRe;
  assign firMuxAdd_20_xRe_fe       = ~firMuxAdd_21_yRe_or;
  assign firMuxAdd_21_yRe_ff       = ~firMuxAdd_20_xRe_ir;

  assign firMuxAdd_20_xIm          = firMuxAdd_21_yIm;
  assign firMuxAdd_20_xIm_fe       = ~firMuxAdd_21_yIm_or;
  assign firMuxAdd_21_yIm_ff       = ~firMuxAdd_20_xIm_ir;

  assign firMuxAdd_19_xRe          = firMuxAdd_20_yRe;
  assign firMuxAdd_19_xRe_fe       = ~firMuxAdd_20_yRe_or;
  assign firMuxAdd_20_yRe_ff       = ~firMuxAdd_19_xRe_ir;

  assign firMuxAdd_19_xIm          = firMuxAdd_20_yIm;
  assign firMuxAdd_19_xIm_fe       = ~firMuxAdd_20_yIm_or;
  assign firMuxAdd_20_yIm_ff       = ~firMuxAdd_19_xIm_ir;

  assign firMuxAdd_18_xRe          = firMuxAdd_19_yRe;
  assign firMuxAdd_18_xRe_fe       = ~firMuxAdd_19_yRe_or;
  assign firMuxAdd_19_yRe_ff       = ~firMuxAdd_18_xRe_ir;

  assign firMuxAdd_18_xIm          = firMuxAdd_19_yIm;
  assign firMuxAdd_18_xIm_fe       = ~firMuxAdd_19_yIm_or;
  assign firMuxAdd_19_yIm_ff       = ~firMuxAdd_18_xIm_ir;

  assign firMuxAdd_17_xRe          = firMuxAdd_18_yRe;
  assign firMuxAdd_17_xRe_fe       = ~firMuxAdd_18_yRe_or;
  assign firMuxAdd_18_yRe_ff       = ~firMuxAdd_17_xRe_ir;

  assign firMuxAdd_17_xIm          = firMuxAdd_18_yIm;
  assign firMuxAdd_17_xIm_fe       = ~firMuxAdd_18_yIm_or;
  assign firMuxAdd_18_yIm_ff       = ~firMuxAdd_17_xIm_ir;

  assign firMuxAdd_16_xRe          = firMuxAdd_17_yRe;
  assign firMuxAdd_16_xRe_fe       = ~firMuxAdd_17_yRe_or;
  assign firMuxAdd_17_yRe_ff       = ~firMuxAdd_16_xRe_ir;

  assign firMuxAdd_16_xIm          = firMuxAdd_17_yIm;
  assign firMuxAdd_16_xIm_fe       = ~firMuxAdd_17_yIm_or;
  assign firMuxAdd_17_yIm_ff       = ~firMuxAdd_16_xIm_ir;

  assign firMuxAdd_15_xRe          = firMuxAdd_16_yRe;
  assign firMuxAdd_15_xRe_fe       = ~firMuxAdd_16_yRe_or;
  assign firMuxAdd_16_yRe_ff       = ~firMuxAdd_15_xRe_ir;

  assign firMuxAdd_15_xIm          = firMuxAdd_16_yIm;
  assign firMuxAdd_15_xIm_fe       = ~firMuxAdd_16_yIm_or;
  assign firMuxAdd_16_yIm_ff       = ~firMuxAdd_15_xIm_ir;

  assign firMuxAdd_14_xRe          = firMuxAdd_15_yRe;
  assign firMuxAdd_14_xRe_fe       = ~firMuxAdd_15_yRe_or;
  assign firMuxAdd_15_yRe_ff       = ~firMuxAdd_14_xRe_ir;

  assign firMuxAdd_14_xIm          = firMuxAdd_15_yIm;
  assign firMuxAdd_14_xIm_fe       = ~firMuxAdd_15_yIm_or;
  assign firMuxAdd_15_yIm_ff       = ~firMuxAdd_14_xIm_ir;

  assign firMuxAdd_13_xRe          = firMuxAdd_14_yRe;
  assign firMuxAdd_13_xRe_fe       = ~firMuxAdd_14_yRe_or;
  assign firMuxAdd_14_yRe_ff       = ~firMuxAdd_13_xRe_ir;

  assign firMuxAdd_13_xIm          = firMuxAdd_14_yIm;
  assign firMuxAdd_13_xIm_fe       = ~firMuxAdd_14_yIm_or;
  assign firMuxAdd_14_yIm_ff       = ~firMuxAdd_13_xIm_ir;

  assign firMuxAdd_12_xRe          = firMuxAdd_13_yRe;
  assign firMuxAdd_12_xRe_fe       = ~firMuxAdd_13_yRe_or;
  assign firMuxAdd_13_yRe_ff       = ~firMuxAdd_12_xRe_ir;

  assign firMuxAdd_12_xIm          = firMuxAdd_13_yIm;
  assign firMuxAdd_12_xIm_fe       = ~firMuxAdd_13_yIm_or;
  assign firMuxAdd_13_yIm_ff       = ~firMuxAdd_12_xIm_ir;

  assign firMuxAdd_11_xRe          = firMuxAdd_12_yRe;
  assign firMuxAdd_11_xRe_fe       = ~firMuxAdd_12_yRe_or;
  assign firMuxAdd_12_yRe_ff       = ~firMuxAdd_11_xRe_ir;

  assign firMuxAdd_11_xIm          = firMuxAdd_12_yIm;
  assign firMuxAdd_11_xIm_fe       = ~firMuxAdd_12_yIm_or;
  assign firMuxAdd_12_yIm_ff       = ~firMuxAdd_11_xIm_ir;

  assign firMuxAdd_10_xRe          = firMuxAdd_11_yRe;
  assign firMuxAdd_10_xRe_fe       = ~firMuxAdd_11_yRe_or;
  assign firMuxAdd_11_yRe_ff       = ~firMuxAdd_10_xRe_ir;

  assign firMuxAdd_10_xIm          = firMuxAdd_11_yIm;
  assign firMuxAdd_10_xIm_fe       = ~firMuxAdd_11_yIm_or;
  assign firMuxAdd_11_yIm_ff       = ~firMuxAdd_10_xIm_ir;

  assign firMuxAdd_09_xRe          = firMuxAdd_10_yRe;
  assign firMuxAdd_09_xRe_fe       = ~firMuxAdd_10_yRe_or;
  assign firMuxAdd_10_yRe_ff       = ~firMuxAdd_09_xRe_ir;

  assign firMuxAdd_09_xIm          = firMuxAdd_10_yIm;
  assign firMuxAdd_09_xIm_fe       = ~firMuxAdd_10_yIm_or;
  assign firMuxAdd_10_yIm_ff       = ~firMuxAdd_09_xIm_ir;

  assign firMuxAdd_08_xRe          = firMuxAdd_09_yRe;
  assign firMuxAdd_08_xRe_fe       = ~firMuxAdd_09_yRe_or;
  assign firMuxAdd_09_yRe_ff       = ~firMuxAdd_08_xRe_ir;

  assign firMuxAdd_08_xIm          = firMuxAdd_09_yIm;
  assign firMuxAdd_08_xIm_fe       = ~firMuxAdd_09_yIm_or;
  assign firMuxAdd_09_yIm_ff       = ~firMuxAdd_08_xIm_ir;

  assign firMuxAdd_07_xRe          = firMuxAdd_08_yRe;
  assign firMuxAdd_07_xRe_fe       = ~firMuxAdd_08_yRe_or;
  assign firMuxAdd_08_yRe_ff       = ~firMuxAdd_07_xRe_ir;

  assign firMuxAdd_07_xIm          = firMuxAdd_08_yIm;
  assign firMuxAdd_07_xIm_fe       = ~firMuxAdd_08_yIm_or;
  assign firMuxAdd_08_yIm_ff       = ~firMuxAdd_07_xIm_ir;

  assign firMuxAdd_06_xRe          = firMuxAdd_07_yRe;
  assign firMuxAdd_06_xRe_fe       = ~firMuxAdd_07_yRe_or;
  assign firMuxAdd_07_yRe_ff       = ~firMuxAdd_06_xRe_ir;

  assign firMuxAdd_06_xIm          = firMuxAdd_07_yIm;
  assign firMuxAdd_06_xIm_fe       = ~firMuxAdd_07_yIm_or;
  assign firMuxAdd_07_yIm_ff       = ~firMuxAdd_06_xIm_ir;

  assign firMuxAdd_05_xRe          = firMuxAdd_06_yRe;
  assign firMuxAdd_05_xRe_fe       = ~firMuxAdd_06_yRe_or;
  assign firMuxAdd_06_yRe_ff       = ~firMuxAdd_05_xRe_ir;

  assign firMuxAdd_05_xIm          = firMuxAdd_06_yIm;
  assign firMuxAdd_05_xIm_fe       = ~firMuxAdd_06_yIm_or;
  assign firMuxAdd_06_yIm_ff       = ~firMuxAdd_05_xIm_ir;

  assign firMuxAdd_04_xRe          = firMuxAdd_05_yRe;
  assign firMuxAdd_04_xRe_fe       = ~firMuxAdd_05_yRe_or;
  assign firMuxAdd_05_yRe_ff       = ~firMuxAdd_04_xRe_ir;

  assign firMuxAdd_04_xIm          = firMuxAdd_05_yIm;
  assign firMuxAdd_04_xIm_fe       = ~firMuxAdd_05_yIm_or;
  assign firMuxAdd_05_yIm_ff       = ~firMuxAdd_04_xIm_ir;

  assign firMuxAdd_03_xRe          = firMuxAdd_04_yRe;
  assign firMuxAdd_03_xRe_fe       = ~firMuxAdd_04_yRe_or;
  assign firMuxAdd_04_yRe_ff       = ~firMuxAdd_03_xRe_ir;

  assign firMuxAdd_03_xIm          = firMuxAdd_04_yIm;
  assign firMuxAdd_03_xIm_fe       = ~firMuxAdd_04_yIm_or;
  assign firMuxAdd_04_yIm_ff       = ~firMuxAdd_03_xIm_ir;

  assign firMuxAdd_02_xRe          = firMuxAdd_03_yRe;
  assign firMuxAdd_02_xRe_fe       = ~firMuxAdd_03_yRe_or;
  assign firMuxAdd_03_yRe_ff       = ~firMuxAdd_02_xRe_ir;

  assign firMuxAdd_02_xIm          = firMuxAdd_03_yIm;
  assign firMuxAdd_02_xIm_fe       = ~firMuxAdd_03_yIm_or;
  assign firMuxAdd_03_yIm_ff       = ~firMuxAdd_02_xIm_ir;

  assign firMuxAdd_01_xRe          = firMuxAdd_02_yRe;
  assign firMuxAdd_01_xRe_fe       = ~firMuxAdd_02_yRe_or;
  assign firMuxAdd_02_yRe_ff       = ~firMuxAdd_01_xRe_ir;

  assign firMuxAdd_01_xIm          = firMuxAdd_02_yIm;
  assign firMuxAdd_01_xIm_fe       = ~firMuxAdd_02_yIm_or;
  assign firMuxAdd_02_yIm_ff       = ~firMuxAdd_01_xIm_ir;

  assign firMuxAdd_00_xRe          = firMuxAdd_01_yRe;
  assign firMuxAdd_00_xRe_fe       = ~firMuxAdd_01_yRe_or;
  assign firMuxAdd_01_yRe_ff       = ~firMuxAdd_00_xRe_ir;

  assign firMuxAdd_00_xIm          = firMuxAdd_01_yIm;
  assign firMuxAdd_00_xIm_fe       = ~firMuxAdd_01_yIm_or;
  assign firMuxAdd_01_yIm_ff       = ~firMuxAdd_00_xIm_ir;

  assign firCxMul_00_xRe           = xRe;
  assign firCxMul_00_xRe_fe        = xRe_fe;
  assign firCxMul_00_xIm           = xIm;
  assign firCxMul_00_xIm_fe        = xIm_fe;
  assign firCxMul_00_xRePlIm       = xRePlIm;
  assign firCxMul_00_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_01_xRe           = xRe;
  assign firCxMul_01_xRe_fe        = xRe_fe;
  assign firCxMul_01_xIm           = xIm;
  assign firCxMul_01_xIm_fe        = xIm_fe;
  assign firCxMul_01_xRePlIm       = xRePlIm;
  assign firCxMul_01_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_02_xRe           = xRe;
  assign firCxMul_02_xRe_fe        = xRe_fe;
  assign firCxMul_02_xIm           = xIm;
  assign firCxMul_02_xIm_fe        = xIm_fe;
  assign firCxMul_02_xRePlIm       = xRePlIm;
  assign firCxMul_02_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_03_xRe           = xRe;
  assign firCxMul_03_xRe_fe        = xRe_fe;
  assign firCxMul_03_xIm           = xIm;
  assign firCxMul_03_xIm_fe        = xIm_fe;
  assign firCxMul_03_xRePlIm       = xRePlIm;
  assign firCxMul_03_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_04_xRe           = xRe;
  assign firCxMul_04_xRe_fe        = xRe_fe;
  assign firCxMul_04_xIm           = xIm;
  assign firCxMul_04_xIm_fe        = xIm_fe;
  assign firCxMul_04_xRePlIm       = xRePlIm;
  assign firCxMul_04_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_05_xRe           = xRe;
  assign firCxMul_05_xRe_fe        = xRe_fe;
  assign firCxMul_05_xIm           = xIm;
  assign firCxMul_05_xIm_fe        = xIm_fe;
  assign firCxMul_05_xRePlIm       = xRePlIm;
  assign firCxMul_05_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_06_xRe           = xRe;
  assign firCxMul_06_xRe_fe        = xRe_fe;
  assign firCxMul_06_xIm           = xIm;
  assign firCxMul_06_xIm_fe        = xIm_fe;
  assign firCxMul_06_xRePlIm       = xRePlIm;
  assign firCxMul_06_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_07_xRe           = xRe;
  assign firCxMul_07_xRe_fe        = xRe_fe;
  assign firCxMul_07_xIm           = xIm;
  assign firCxMul_07_xIm_fe        = xIm_fe;
  assign firCxMul_07_xRePlIm       = xRePlIm;
  assign firCxMul_07_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_08_xRe           = xRe;
  assign firCxMul_08_xRe_fe        = xRe_fe;
  assign firCxMul_08_xIm           = xIm;
  assign firCxMul_08_xIm_fe        = xIm_fe;
  assign firCxMul_08_xRePlIm       = xRePlIm;
  assign firCxMul_08_xRePlIm_fe    = xRePlIm_fe;
  assign firCxMul_09_xRe           = xRe;
  assign firCxMul_09_xRe_fe        = xRe_fe;
  assign firCxMul_09_xIm           = xIm;
  assign firCxMul_09_xIm_fe        = xIm_fe;
  assign firCxMul_09_xRePlIm       = xRePlIm;
  assign firCxMul_09_xRePlIm_fe    = xRePlIm_fe;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | firCxMul_00_regWe | firCxMul_01_regWe | firCxMul_02_regWe
                      | firCxMul_03_regWe | firCxMul_04_regWe | firCxMul_05_regWe
                      | firCxMul_06_regWe | firCxMul_07_regWe | firCxMul_08_regWe
                      | firCxMul_09_regWe | firMuxAdd_00_regWe | firMuxAdd_01_regWe
                      | firMuxAdd_02_regWe | firMuxAdd_03_regWe | firMuxAdd_04_regWe
                      | firMuxAdd_05_regWe | firMuxAdd_06_regWe | firMuxAdd_07_regWe
                      | firMuxAdd_08_regWe | firMuxAdd_09_regWe | firMuxAdd_10_regWe
                      | firMuxAdd_11_regWe | firMuxAdd_12_regWe | firMuxAdd_13_regWe
                      | firMuxAdd_14_regWe | firMuxAdd_15_regWe | firMuxAdd_16_regWe
                      | firMuxAdd_17_regWe | firMuxAdd_18_regWe | firMuxAdd_19_regWe
                      | firMuxAdd_20_regWe | firMuxAdd_21_regWe | firMuxAdd_22_regWe
                      | firMuxAdd_23_regWe | firMuxAdd_24_regWe | firMuxAdd_25_regWe
                      | firMuxAdd_26_regWe | firMuxAdd_27_regWe | firMuxAdd_28_regWe
                      | firMuxAdd_29_regWe;
  assign regReOut = 0 | firCxMul_00_regRe | firCxMul_01_regRe | firCxMul_02_regRe
                      | firCxMul_03_regRe | firCxMul_04_regRe | firCxMul_05_regRe
                      | firCxMul_06_regRe | firCxMul_07_regRe | firCxMul_08_regRe
                      | firCxMul_09_regRe | firMuxAdd_00_regRe | firMuxAdd_01_regRe
                      | firMuxAdd_02_regRe | firMuxAdd_03_regRe | firMuxAdd_04_regRe
                      | firMuxAdd_05_regRe | firMuxAdd_06_regRe | firMuxAdd_07_regRe
                      | firMuxAdd_08_regRe | firMuxAdd_09_regRe | firMuxAdd_10_regRe
                      | firMuxAdd_11_regRe | firMuxAdd_12_regRe | firMuxAdd_13_regRe
                      | firMuxAdd_14_regRe | firMuxAdd_15_regRe | firMuxAdd_16_regRe
                      | firMuxAdd_17_regRe | firMuxAdd_18_regRe | firMuxAdd_19_regRe
                      | firMuxAdd_20_regRe | firMuxAdd_21_regRe | firMuxAdd_22_regRe
                      | firMuxAdd_23_regRe | firMuxAdd_24_regRe | firMuxAdd_25_regRe
                      | firMuxAdd_26_regRe | firMuxAdd_27_regRe | firMuxAdd_28_regRe
                      | firMuxAdd_29_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  assign yRe_or = xRe_re;
  assign yIm_or = xIm_re;
  assign yRe    = xRe;
  assign yIm    = xIm;

endmodule
//=========================================================================================

