//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mainTx
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mainTx(yRe, yRe_or, yRe_ff, yRe_we, 
              yIm, yIm_or, yIm_ff, yIm_we, 
              xRe, xRe_ir, xRe_fe, xRe_re, 
              xIm, xIm_ir, xIm_fe, xIm_re, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "dacSim_0.v"
  `include "txScale_0.v"
  `include "iqImb_0.v"
  `include "dcOff_0.v"
  `include "pa_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign txScale_0_xRe             = dacSim_0_yRe;
  assign txScale_0_xRe_fe          = ~dacSim_0_yRe_or;
  assign dacSim_0_yRe_ff           = ~txScale_0_xRe_ir;

  assign txScale_0_xIm             = dacSim_0_yIm;
  assign txScale_0_xIm_fe          = ~dacSim_0_yIm_or;
  assign dacSim_0_yIm_ff           = ~txScale_0_xIm_ir;

  assign iqImb_0_xRe               = txScale_0_yRe;
  assign iqImb_0_xRe_fe            = ~txScale_0_yRe_or;
  assign txScale_0_yRe_ff          = ~iqImb_0_xRe_ir;

  assign iqImb_0_xIm               = txScale_0_yIm;
  assign iqImb_0_xIm_fe            = ~txScale_0_yIm_or;
  assign txScale_0_yIm_ff          = ~iqImb_0_xIm_ir;

  assign dcOff_0_xRe               = iqImb_0_yRe;
  assign dcOff_0_xRe_fe            = ~iqImb_0_yRe_or;
  assign iqImb_0_yRe_ff            = ~dcOff_0_xRe_ir;

  assign dcOff_0_xIm               = iqImb_0_yIm;
  assign dcOff_0_xIm_fe            = ~iqImb_0_yIm_or;
  assign iqImb_0_yIm_ff            = ~dcOff_0_xIm_ir;

  assign pa_0_xRe                  = dcOff_0_yRe;
  assign pa_0_xRe_fe               = ~dcOff_0_yRe_or;
  assign dcOff_0_yRe_ff            = ~pa_0_xRe_ir;

  assign pa_0_xIm                  = dcOff_0_yIm;
  assign pa_0_xIm_fe               = ~dcOff_0_yIm_or;
  assign dcOff_0_yIm_ff            = ~pa_0_xIm_ir;

  assign yRe                       = pa_0_yRe;
  assign yRe_or                    = pa_0_yRe_or;
  assign pa_0_yRe_ff               = yRe_ff;

  assign yIm                       = pa_0_yIm;
  assign yIm_or                    = pa_0_yIm_or;
  assign pa_0_yIm_ff               = yIm_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | dacSim_0_regWe | txScale_0_regWe | iqImb_0_regWe
                      | dcOff_0_regWe | pa_0_regWe;
  assign regReOut = 0 | dacSim_0_regRe | txScale_0_regRe | iqImb_0_regRe
                      | dcOff_0_regRe | pa_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Connect input to the upper 12 of 16 bits  
  assign dacSim_0_xRe              = {xRe, 4'b0000};
  assign dacSim_0_xRe_fe           = xRe_fe;
  assign xRe_ir                    = dacSim_0_xRe_ir;

  assign dacSim_0_xIm              = {xIm, 4'b0000};
  assign dacSim_0_xIm_fe           = xIm_fe;
  assign xIm_ir                    = dacSim_0_xIm_ir;

endmodule
//=========================================================================================

