//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mainRx
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mainRx(yRe, yRe_or, yRe_ff, yRe_we, 
              yIm, yIm_or, yIm_ff, yIm_we, 
              xRe, xRe_ir, xRe_fe, xRe_re, 
              xIm, xIm_ir, xIm_fe, xIm_re, 
              gainSel, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;

  parameter gainSel_w         = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wg                = 0;
  parameter wf                = 0;
  parameter ws                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input       [gainSel_w-1:0]  gainSel;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "awgn_0.v"
  `include "gainCtrl_0.v"
  `include "iqImb_0.v"
  `include "dcOff_0.v"
  `include "shrRndSat_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign awgn_0_xRe                = xRe;
  assign awgn_0_xRe_fe             = xRe_fe;
  assign xRe_ir                    = awgn_0_xRe_ir;

  assign awgn_0_xIm                = xIm;
  assign awgn_0_xIm_fe             = xIm_fe;
  assign xIm_ir                    = awgn_0_xIm_ir;

  assign gainCtrl_0_xRe            = awgn_0_yRe;
  assign gainCtrl_0_xRe_fe         = ~awgn_0_yRe_or;
  assign awgn_0_yRe_ff             = ~gainCtrl_0_xRe_ir;

  assign gainCtrl_0_xIm            = awgn_0_yIm;
  assign gainCtrl_0_xIm_fe         = ~awgn_0_yIm_or;
  assign awgn_0_yIm_ff             = ~gainCtrl_0_xIm_ir;

  assign iqImb_0_xRe               = gainCtrl_0_yRe;
  assign iqImb_0_xRe_fe            = ~gainCtrl_0_yRe_or;
  assign gainCtrl_0_yRe_ff         = ~iqImb_0_xRe_ir;

  assign iqImb_0_xIm               = gainCtrl_0_yIm;
  assign iqImb_0_xIm_fe            = ~gainCtrl_0_yIm_or;
  assign gainCtrl_0_yIm_ff         = ~iqImb_0_xIm_ir;

  assign gainCtrl_0_gainSel        = gainSel;
  assign dcOff_0_xRe               = iqImb_0_yRe;
  assign dcOff_0_xRe_fe            = ~iqImb_0_yRe_or;
  assign iqImb_0_yRe_ff            = ~dcOff_0_xRe_ir;

  assign dcOff_0_xIm               = iqImb_0_yIm;
  assign dcOff_0_xIm_fe            = ~iqImb_0_yIm_or;
  assign iqImb_0_yIm_ff            = ~dcOff_0_xIm_ir;

  assign shrRndSat_0_xRe           = dcOff_0_yRe;
  assign shrRndSat_0_xRe_fe        = ~dcOff_0_yRe_or;
  assign dcOff_0_yRe_ff            = ~shrRndSat_0_xRe_ir;

  assign shrRndSat_0_xIm           = dcOff_0_yIm;
  assign shrRndSat_0_xIm_fe        = ~dcOff_0_yIm_or;
  assign dcOff_0_yIm_ff            = ~shrRndSat_0_xIm_ir;

  assign yRe                       = shrRndSat_0_yRe;
  assign yRe_or                    = shrRndSat_0_yRe_or;
  assign shrRndSat_0_yRe_ff        = yRe_ff;

  assign yIm                       = shrRndSat_0_yIm;
  assign yIm_or                    = shrRndSat_0_yIm_or;
  assign shrRndSat_0_yIm_ff        = yIm_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | awgn_0_regWe | gainCtrl_0_regWe | iqImb_0_regWe
                      | dcOff_0_regWe | shrRndSat_0_regWe;
  assign regReOut = 0 | awgn_0_regRe | gainCtrl_0_regRe | iqImb_0_regRe
                      | dcOff_0_regRe | shrRndSat_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================


endmodule
//=========================================================================================

