//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mainChan
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mainChan(yRe, yRe_or, yRe_ff, yRe_we, 
                yIm, yIm_or, yIm_ff, yIm_we, 
                xRe, xRe_ir, xRe_fe, xRe_re, 
                xIm, xIm_ir, xIm_fe, xIm_re, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter wx                = 0;
  parameter wy                = 0;

  parameter tOffInRe_w        = 0;
  parameter tOffInRe_n        = 0;
  parameter tOffInRe_m        = 0;
  parameter R_tOffInRe        = 0;
  parameter tOffInIm_w        = 0;
  parameter tOffInIm_n        = 0;
  parameter tOffInIm_m        = 0;
  parameter R_tOffInIm        = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "multiPath_0.v"
  `include "timeOff_0.v"
  `include "freqOff_0.v"
  `include "gainChan_0.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo multiPath_0_yRe -> timeOff_0_xRe
  wire     [tOffInRe_w-1:0]  tOffInRe_q;
  wire                       tOffInRe_fe;
  wire                       tOffInRe_ff;
  wire                       tOffInRe_ff2;
  wire                       tOffInRe_fuf;
  wire                       tOffInRe_fof;
  wire     [tOffInRe_w-1:0]  tOffInRe_d;
  wire                       tOffInRe_re;
  wire                       tOffInRe_we;
  wire                       tOffInRe_ir;
  wire                       tOffInRe_or;

  fifoA tOffInRe(tOffInRe_q, tOffInRe_fe, tOffInRe_ff, tOffInRe_ff2, tOffInRe_fuf,
                 tOffInRe_fof, tOffInRe_d, tOffInRe_re, tOffInRe_we, tOffInRe_ir,
                 tOffInRe_or, regBus, regWe, clk);
  defparam tOffInRe.w = tOffInRe_w;
  defparam tOffInRe.m = tOffInRe_m;
  defparam tOffInRe.n = tOffInRe_n;
  defparam tOffInRe.a = R_tOffInRe;

  assign tOffInRe_d                = multiPath_0_yRe;
  assign tOffInRe_we               = multiPath_0_yRe_we;
  assign multiPath_0_yRe_ff        = tOffInRe_ff;
  assign tOffInRe_or               = multiPath_0_yRe_or;

  assign timeOff_0_xRe             = tOffInRe_q;
  assign timeOff_0_xRe_fe          = tOffInRe_fe;
  assign tOffInRe_re               = timeOff_0_xRe_re;
  assign tOffInRe_ir               = timeOff_0_xRe_ir;


  // ----------------------------------------
  // Fifo multiPath_0_yIm -> timeOff_0_xIm
  wire     [tOffInIm_w-1:0]  tOffInIm_q;
  wire                       tOffInIm_fe;
  wire                       tOffInIm_ff;
  wire                       tOffInIm_ff2;
  wire                       tOffInIm_fuf;
  wire                       tOffInIm_fof;
  wire     [tOffInIm_w-1:0]  tOffInIm_d;
  wire                       tOffInIm_re;
  wire                       tOffInIm_we;
  wire                       tOffInIm_ir;
  wire                       tOffInIm_or;

  fifoA tOffInIm(tOffInIm_q, tOffInIm_fe, tOffInIm_ff, tOffInIm_ff2, tOffInIm_fuf,
                 tOffInIm_fof, tOffInIm_d, tOffInIm_re, tOffInIm_we, tOffInIm_ir,
                 tOffInIm_or, regBus, regWe, clk);
  defparam tOffInIm.w = tOffInIm_w;
  defparam tOffInIm.m = tOffInIm_m;
  defparam tOffInIm.n = tOffInIm_n;
  defparam tOffInIm.a = R_tOffInIm;

  assign tOffInIm_d                = multiPath_0_yIm;
  assign tOffInIm_we               = multiPath_0_yIm_we;
  assign multiPath_0_yIm_ff        = tOffInIm_ff;
  assign tOffInIm_or               = multiPath_0_yIm_or;

  assign timeOff_0_xIm             = tOffInIm_q;
  assign timeOff_0_xIm_fe          = tOffInIm_fe;
  assign tOffInIm_re               = timeOff_0_xIm_re;
  assign tOffInIm_ir               = timeOff_0_xIm_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign multiPath_0_xRe           = xRe;
  assign multiPath_0_xRe_fe        = xRe_fe;
  assign xRe_ir                    = multiPath_0_xRe_ir;

  assign multiPath_0_xIm           = xIm;
  assign multiPath_0_xIm_fe        = xIm_fe;
  assign xIm_ir                    = multiPath_0_xIm_ir;

  assign freqOff_0_xRe             = timeOff_0_yRe;
  assign freqOff_0_xRe_fe          = ~timeOff_0_yRe_or;
  assign timeOff_0_yRe_ff          = ~freqOff_0_xRe_ir;

  assign freqOff_0_xIm             = timeOff_0_yIm;
  assign freqOff_0_xIm_fe          = ~timeOff_0_yIm_or;
  assign timeOff_0_yIm_ff          = ~freqOff_0_xIm_ir;

  assign gainChan_0_xRe            = freqOff_0_yRe;
  assign gainChan_0_xRe_fe         = ~freqOff_0_yRe_or;
  assign freqOff_0_yRe_ff          = ~gainChan_0_xRe_ir;

  assign gainChan_0_xIm            = freqOff_0_yIm;
  assign gainChan_0_xIm_fe         = ~freqOff_0_yIm_or;
  assign freqOff_0_yIm_ff          = ~gainChan_0_xIm_ir;

  assign yRe                       = gainChan_0_yRe;
  assign yRe_or                    = gainChan_0_yRe_or;
  assign gainChan_0_yRe_ff         = yRe_ff;

  assign yIm                       = gainChan_0_yIm;
  assign yIm_or                    = gainChan_0_yIm_or;
  assign gainChan_0_yIm_ff         = yIm_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | multiPath_0_regWe | timeOff_0_regWe | freqOff_0_regWe
                      | gainChan_0_regWe;
  assign regReOut = 0 | multiPath_0_regRe | timeOff_0_regRe | freqOff_0_regRe
                      | gainChan_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================


endmodule
//=========================================================================================

