//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   lut
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module lut(dat, dat_or, dat_ff, dat_we, 
           adr, adr_ir, adr_fe, adr_re, 
           regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter dat_w             = 0;
  parameter adr_w             = 0;


  parameter wrAdr_w           = 0;
  parameter wrAdr_r           = 0;
  parameter wrAdr_s           = 0;
  parameter R_wrAdr           = 0;
  parameter wrDatHi_w         = 0;
  parameter wrDatHi_r         = 0;
  parameter wrDatHi_s         = 0;
  parameter R_wrDatHi         = 0;
  parameter wrDatLo_w         = 0;
  parameter wrDatLo_r         = 0;
  parameter wrDatLo_s         = 0;
  parameter R_wrDatLo         = 0;
  parameter simInit_w         = 0;
  parameter simInit_r         = 0;
  parameter simInit_s         = 0;
  parameter R_simInit         = 0;

  parameter w                 = 0;
  parameter n                 = 0;
  parameter m                 = 0;
  parameter lutDat            = 0;

  parameter lutMem_w          = 0;
  parameter lutMem_n          = 0;
  parameter lutMem_m          = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [dat_w-1:0]  dat;
  output                       dat_or;
  input                        dat_ff;
  output                       dat_we;
  assign                       dat_we = dat_or & ~dat_ff;

  input           [adr_w-1:0]  adr;
  output                       adr_ir;
  input                        adr_fe;
  output                       adr_re;
  assign                       adr_re = adr_ir & ~adr_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire          [wrAdr_w-1:0]  wrAdr_q;
  wire          [wrAdr_w-1:0]  wrAdr_d;
  wire                         wrAdr_weint;
  assign                       wrAdr_weint = 0;

  wire        [wrDatHi_w-1:0]  wrDatHi_q;
  wire        [wrDatHi_w-1:0]  wrDatHi_d;
  wire                         wrDatHi_weint;
  assign                       wrDatHi_weint = 0;

  wire        [wrDatLo_w-1:0]  wrDatLo_q;
  wire        [wrDatLo_w-1:0]  wrDatLo_d;
  wire                         wrDatLo_weint;
  assign                       wrDatLo_weint = 0;

  wire        [simInit_w-1:0]  simInit_q;
  wire        [simInit_w-1:0]  simInit_d;
  wire                         simInit_weint;
  assign                       simInit_weint = 0;

  // Wires for internal memories
  wire         [lutMem_w-1:0]  lutMem_q;
  wire         [lutMem_w-1:0]  lutMem_d;
  wire         [lutMem_m-1:0]  lutMem_adr;
  wire                         lutMem_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg wrAdr(wrAdr_q, regBus, wrAdr_d, wrAdr_weint, regWe, regRe, clk, reset);
  defparam wrAdr.w    = wrAdr_w;
  defparam wrAdr.rval = wrAdr_r;
  defparam wrAdr.sgn  = wrAdr_s;
  defparam wrAdr.adr  = R_wrAdr;

  ereg wrDatHi(wrDatHi_q, regBus, wrDatHi_d, wrDatHi_weint, regWe, regRe, clk, reset);
  defparam wrDatHi.w    = wrDatHi_w;
  defparam wrDatHi.rval = wrDatHi_r;
  defparam wrDatHi.sgn  = wrDatHi_s;
  defparam wrDatHi.adr  = R_wrDatHi;

  ereg wrDatLo(wrDatLo_q, regBus, wrDatLo_d, wrDatLo_weint, regWe, regRe, clk, reset);
  defparam wrDatLo.w    = wrDatLo_w;
  defparam wrDatLo.rval = wrDatLo_r;
  defparam wrDatLo.sgn  = wrDatLo_s;
  defparam wrDatLo.adr  = R_wrDatLo;

  ereg simInit(simInit_q, regBus, simInit_d, simInit_weint, regWe, regRe, clk, reset);
  defparam simInit.w    = simInit_w;
  defparam simInit.rval = simInit_r;
  defparam simInit.sgn  = simInit_s;
  defparam simInit.adr  = R_simInit;

  // --------------------------------------------------------------------------------------
  // Internal single ported memories
  spRam1 lutMem(lutMem_q, lutMem_d, lutMem_adr, lutMem_we, clk);
  defparam lutMem.w    = lutMem_w;
  defparam lutMem.n    = lutMem_n;
  defparam lutMem.m    = lutMem_m;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================
  wire   [31:0] wrDat;
  reg           we;
  
  always @(posedge clk)
    we <= regWe & (regBus==R_wrDatLo);

  assign wrDat = {wrDatHi_q, regBus};
  assign lutMem_d   = wrDat[w-1:0];
  assign lutMem_adr = we ? wrAdr_q : adr;
  assign lutMem_we  = we;
  assign dat = lutMem_q;
  
endmodule
//========================================================================================
        
