//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   iqImb
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module iqImb(yRe, yRe_or, yRe_ff, yRe_we, 
             yIm, yIm_or, yIm_ff, yIm_we, 
             xRe, xRe_ir, xRe_fe, xRe_re, 
             xIm, xIm_ir, xIm_fe, xIm_re, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter a_w               = 0;
  parameter a_r               = 0;
  parameter a_s               = 0;
  parameter R_a               = 0;
  parameter b_w               = 0;
  parameter b_r               = 0;
  parameter b_s               = 0;
  parameter R_b               = 0;
  parameter c_w               = 0;
  parameter c_r               = 0;
  parameter c_s               = 0;
  parameter R_c               = 0;

  parameter w                 = 0;

  parameter yReR_w            = 0;
  parameter yReR_n            = 0;
  parameter yReR_m            = 0;
  parameter yImR_w            = 0;
  parameter yImR_n            = 0;
  parameter yImR_m            = 0;
  parameter mA_w              = 0;
  parameter mA_n              = 0;
  parameter mA_m              = 0;
  parameter mB_w              = 0;
  parameter mB_n              = 0;
  parameter mB_m              = 0;
  parameter mC_w              = 0;
  parameter mC_n              = 0;
  parameter mC_m              = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire              [a_w-1:0]  a_q;
  wire              [a_w-1:0]  a_d;
  wire                         a_weint;
  assign                       a_weint = 0;

  wire              [b_w-1:0]  b_q;
  wire              [b_w-1:0]  b_d;
  wire                         b_weint;
  assign                       b_weint = 0;

  wire              [c_w-1:0]  c_q;
  wire              [c_w-1:0]  c_d;
  wire                         c_weint;
  assign                       c_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg a(a_q, regBus, a_d, a_weint, regWe, regRe, clk, reset);
  defparam a.w    = a_w;
  defparam a.rval = a_r;
  defparam a.sgn  = a_s;
  defparam a.adr  = R_a;

  ereg b(b_q, regBus, b_d, b_weint, regWe, regRe, clk, reset);
  defparam b.w    = b_w;
  defparam b.rval = b_r;
  defparam b.sgn  = b_s;
  defparam b.adr  = R_b;

  ereg c(c_q, regBus, c_d, c_weint, regWe, regRe, clk, reset);
  defparam c.w    = c_w;
  defparam c.rval = c_r;
  defparam c.sgn  = c_s;
  defparam c.adr  = R_c;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg            [yReR_w-1:0]  yReR;
  reg            [yImR_w-1:0]  yImR;
  reg              [mA_w-1:0]  mA;
  reg              [mB_w-1:0]  mB;
  reg              [mC_w-1:0]  mC;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;
  assign yRe_or = xRe_re;
  assign yIm_or = xIm_re;
  assign yRe    = xRe;
  assign yIm    = xIm;
  
endmodule
//=========================================================================================

