//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter uart16_vrf_txExtIf_w       = 16;

  // Outputs
  parameter uart16_vrf_rxExtIf_w       = 16;

  // Input control lines
  parameter uart16_vrf_rxs_w           = 1;

  // Output control lines
  parameter uart16_vrf_txs_w           = 1;

  // Eregs
  parameter uart16_vrf_div_w           = 14;
  parameter uart16_vrf_div_r           = VrfUartDivider_C;
  parameter uart16_vrf_div_s           = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam uart16_vrf.txExtIf_w       = uart16_vrf_txExtIf_w;
  defparam uart16_vrf.rxExtIf_w       = uart16_vrf_rxExtIf_w;
  defparam uart16_vrf.rxs_w           = uart16_vrf_rxs_w;
  defparam uart16_vrf.txs_w           = uart16_vrf_txs_w;
  defparam uart16_vrf.div_w           = uart16_vrf_div_w;
  defparam uart16_vrf.div_r           = uart16_vrf_div_r;
  defparam uart16_vrf.div_s           = uart16_vrf_div_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_uart16_vrf_div                                             = 0;
  defparam  uart16_vrf.R_div                                             = R_uart16_vrf_div;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire          [uart16_vrf_rxExtIf_w-1:0]  uart16_vrf_rxExtIf;
  wire                                      uart16_vrf_rxExtIf_or;
  wire                                      uart16_vrf_rxExtIf_ff;
  wire                                      uart16_vrf_rxExtIf_we;

  wire          [uart16_vrf_txExtIf_w-1:0]  uart16_vrf_txExtIf;
  wire                                      uart16_vrf_txExtIf_ir;
  wire                                      uart16_vrf_txExtIf_fe;
  wire                                      uart16_vrf_txExtIf_re;

  wire              [uart16_vrf_txs_w-1:0]  uart16_vrf_txs;

  wire              [uart16_vrf_rxs_w-1:0]  uart16_vrf_rxs;

  wire                                      uart16_vrf_regWe;
  wire                                      uart16_vrf_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  uart16 uart16_vrf(uart16_vrf_rxExtIf, uart16_vrf_rxExtIf_or, uart16_vrf_rxExtIf_ff, uart16_vrf_rxExtIf_we,
                    uart16_vrf_txExtIf, uart16_vrf_txExtIf_ir, uart16_vrf_txExtIf_fe, uart16_vrf_txExtIf_re, 
                    uart16_vrf_txs, 
                    uart16_vrf_rxs, 
                    regBus, regWe, regRe, uart16_vrf_regWe, uart16_vrf_regRe, clk, clk2, reset);


//==============================================================================
