//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter txScale_0_xRe_w           = 16;
  parameter txScale_0_xIm_w           = 16;

  // Outputs
  parameter txScale_0_yRe_w           = 16;
  parameter txScale_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs
  parameter txScale_0_run1_w          = 1;
  parameter txScale_0_run1_r          = 0;
  parameter txScale_0_run1_s          = 0;
  parameter txScale_0_txFactor_w      = 15;
  parameter txScale_0_txFactor_r      = 0;
  parameter txScale_0_txFactor_s      = 0;

  // Parameters
  parameter txScale_0_w               = 16;
  parameter txScale_0_ws              = 15;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam txScale_0.xRe_w           = txScale_0_xRe_w;
  defparam txScale_0.xIm_w           = txScale_0_xIm_w;
  defparam txScale_0.yRe_w           = txScale_0_yRe_w;
  defparam txScale_0.yIm_w           = txScale_0_yIm_w;
  defparam txScale_0.run1_w          = txScale_0_run1_w;
  defparam txScale_0.run1_r          = txScale_0_run1_r;
  defparam txScale_0.run1_s          = txScale_0_run1_s;
  defparam txScale_0.txFactor_w      = txScale_0_txFactor_w;
  defparam txScale_0.txFactor_r      = txScale_0_txFactor_r;
  defparam txScale_0.txFactor_s      = txScale_0_txFactor_s;
  defparam txScale_0.w               = txScale_0_w;
  defparam txScale_0.ws              = txScale_0_ws;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_txScale_0_run1                                             = 0;
  defparam  txScale_0.R_run1                                             = R_txScale_0_run1;
  parameter R_txScale_0_txFactor                                         = 1;
  defparam  txScale_0.R_txFactor                                         = R_txScale_0_txFactor;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [txScale_0_yRe_w-1:0]  txScale_0_yRe;
  wire                                      txScale_0_yRe_or;
  wire                                      txScale_0_yRe_ff;
  wire                                      txScale_0_yRe_we;

  wire               [txScale_0_yIm_w-1:0]  txScale_0_yIm;
  wire                                      txScale_0_yIm_or;
  wire                                      txScale_0_yIm_ff;
  wire                                      txScale_0_yIm_we;

  wire               [txScale_0_xRe_w-1:0]  txScale_0_xRe;
  wire                                      txScale_0_xRe_ir;
  wire                                      txScale_0_xRe_fe;
  wire                                      txScale_0_xRe_re;

  wire               [txScale_0_xIm_w-1:0]  txScale_0_xIm;
  wire                                      txScale_0_xIm_ir;
  wire                                      txScale_0_xIm_fe;
  wire                                      txScale_0_xIm_re;

  wire                                      txScale_0_regWe;
  wire                                      txScale_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  txScale txScale_0(txScale_0_yRe, txScale_0_yRe_or, txScale_0_yRe_ff, txScale_0_yRe_we,
                    txScale_0_yIm, txScale_0_yIm_or, txScale_0_yIm_ff, txScale_0_yIm_we,
                    txScale_0_xRe, txScale_0_xRe_ir, txScale_0_xRe_fe, txScale_0_xRe_re, 
                    txScale_0_xIm, txScale_0_xIm_ir, txScale_0_xIm_fe, txScale_0_xIm_re, 
                    regBus, regWe, regRe, txScale_0_regWe, txScale_0_regRe, clk, clk2, reset);


//==============================================================================
