//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter timeOff_0_xRe_w           = 16;
  parameter timeOff_0_xIm_w           = 16;

  // Outputs
  parameter timeOff_0_yRe_w           = 16;
  parameter timeOff_0_yIm_w           = 16;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter timeOff_0_w               = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam timeOff_0.xRe_w           = timeOff_0_xRe_w;
  defparam timeOff_0.xIm_w           = timeOff_0_xIm_w;
  defparam timeOff_0.yRe_w           = timeOff_0_yRe_w;
  defparam timeOff_0.yIm_w           = timeOff_0_yIm_w;
  defparam timeOff_0.w               = timeOff_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_timeOff_0_firToff_0_run1                                   = 0;
  defparam  timeOff_0.R_firToff_0_run1                                   = R_timeOff_0_firToff_0_run1;
  parameter R_timeOff_0_coeffToff_0_run1                                 = 1;
  defparam  timeOff_0.R_coeffToff_0_run1                                 = R_timeOff_0_coeffToff_0_run1;
  parameter R_timeOff_0_coeffToff_0_byPass                               = 2;
  defparam  timeOff_0.R_coeffToff_0_byPass                               = R_timeOff_0_coeffToff_0_byPass;
  parameter R_timeOff_0_coeffToff_0_tOffLo16                             = 3;
  defparam  timeOff_0.R_coeffToff_0_tOffLo16                             = R_timeOff_0_coeffToff_0_tOffLo16;
  parameter R_timeOff_0_coeffToff_0_tOffMi16                             = 4;
  defparam  timeOff_0.R_coeffToff_0_tOffMi16                             = R_timeOff_0_coeffToff_0_tOffMi16;
  parameter R_timeOff_0_coeffToff_0_tOffHi16                             = 5;
  defparam  timeOff_0.R_coeffToff_0_tOffHi16                             = R_timeOff_0_coeffToff_0_tOffHi16;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [timeOff_0_yRe_w-1:0]  timeOff_0_yRe;
  wire                                      timeOff_0_yRe_or;
  wire                                      timeOff_0_yRe_ff;
  wire                                      timeOff_0_yRe_we;

  wire               [timeOff_0_yIm_w-1:0]  timeOff_0_yIm;
  wire                                      timeOff_0_yIm_or;
  wire                                      timeOff_0_yIm_ff;
  wire                                      timeOff_0_yIm_we;

  wire               [timeOff_0_xRe_w-1:0]  timeOff_0_xRe;
  wire                                      timeOff_0_xRe_ir;
  wire                                      timeOff_0_xRe_fe;
  wire                                      timeOff_0_xRe_re;

  wire               [timeOff_0_xIm_w-1:0]  timeOff_0_xIm;
  wire                                      timeOff_0_xIm_ir;
  wire                                      timeOff_0_xIm_fe;
  wire                                      timeOff_0_xIm_re;

  wire                                      timeOff_0_regWe;
  wire                                      timeOff_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  timeOff timeOff_0(timeOff_0_yRe, timeOff_0_yRe_or, timeOff_0_yRe_ff, timeOff_0_yRe_we,
                    timeOff_0_yIm, timeOff_0_yIm_or, timeOff_0_yIm_ff, timeOff_0_yIm_we,
                    timeOff_0_xRe, timeOff_0_xRe_ir, timeOff_0_xRe_fe, timeOff_0_xRe_re, 
                    timeOff_0_xIm, timeOff_0_xIm_ir, timeOff_0_xIm_fe, timeOff_0_xIm_re, 
                    regBus, regWe, regRe, timeOff_0_regWe, timeOff_0_regRe, clk, clk2, reset);


//==============================================================================
